@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevelArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.LockLevel
import com.pulumi.azurenative.authorization.kotlin.inputs.ManagementLockOwnerArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ManagementLockOwnerArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The lock information.
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * ## Example Usage
 * ### Create management lock at subscription level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementLockAtSubscriptionLevel = new AzureNative.Authorization.ManagementLockAtSubscriptionLevel("managementLockAtSubscriptionLevel", new()
 *     {
 *         Level = AzureNative.Authorization.LockLevel.ReadOnly,
 *         LockName = "testlock",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewManagementLockAtSubscriptionLevel(ctx, "managementLockAtSubscriptionLevel", &authorization.ManagementLockAtSubscriptionLevelArgs{
 * 			Level:    pulumi.String(authorization.LockLevelReadOnly),
 * 			LockName: pulumi.String("testlock"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevel;
 * import com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementLockAtSubscriptionLevel = new ManagementLockAtSubscriptionLevel("managementLockAtSubscriptionLevel", ManagementLockAtSubscriptionLevelArgs.builder()
 *             .level("ReadOnly")
 *             .lockName("testlock")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ManagementLockAtSubscriptionLevel testlock /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}
 * ```
 * @property level The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
 * @property lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &, :, \, ?, /, or any control characters.
 * @property notes Notes about the lock. Maximum of 512 characters.
 * @property owners The owners of the lock.
 */
public data class ManagementLockAtSubscriptionLevelArgs(
    public val level: Output<Either<String, LockLevel>>? = null,
    public val lockName: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val owners: Output<List<ManagementLockOwnerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevelArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevelArgs = com.pulumi.azurenative.authorization.ManagementLockAtSubscriptionLevelArgs.builder()
        .level(
            level?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .lockName(lockName?.applyValue({ args0 -> args0 }))
        .notes(notes?.applyValue({ args0 -> args0 }))
        .owners(
            owners?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [ManagementLockAtSubscriptionLevelArgs].
 */
@PulumiTagMarker
public class ManagementLockAtSubscriptionLevelArgsBuilder internal constructor() {
    private var level: Output<Either<String, LockLevel>>? = null

    private var lockName: Output<String>? = null

    private var notes: Output<String>? = null

    private var owners: Output<List<ManagementLockOwnerArgs>>? = null

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("ybnpijoxxsbcwjki")
    public suspend fun level(`value`: Output<Either<String, LockLevel>>) {
        this.level = value
    }

    /**
     * @param value The name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &, :, \, ?, /, or any control characters.
     */
    @JvmName("ivefmwuwcddnkycx")
    public suspend fun lockName(`value`: Output<String>) {
        this.lockName = value
    }

    /**
     * @param value Notes about the lock. Maximum of 512 characters.
     */
    @JvmName("wxhwpygopmpetuuc")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The owners of the lock.
     */
    @JvmName("ytaqnqtejlrljcoc")
    public suspend fun owners(`value`: Output<List<ManagementLockOwnerArgs>>) {
        this.owners = value
    }

    @JvmName("cxlfuydtjcsqklue")
    public suspend fun owners(vararg values: Output<ManagementLockOwnerArgs>) {
        this.owners = Output.all(values.asList())
    }

    /**
     * @param values The owners of the lock.
     */
    @JvmName("vydqvcnyeoplnhqk")
    public suspend fun owners(values: List<Output<ManagementLockOwnerArgs>>) {
        this.owners = Output.all(values)
    }

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("qsspeoodvjbfohhd")
    public suspend fun level(`value`: Either<String, LockLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("iruhxxelnrnrtsdk")
    public fun level(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LockLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("qcjfxyqvvdqlxgly")
    public fun level(`value`: LockLevel) {
        val toBeMapped = Either.ofRight<String, LockLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &, :, \, ?, /, or any control characters.
     */
    @JvmName("jyfgbglyxhqgconw")
    public suspend fun lockName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockName = mapped
    }

    /**
     * @param value Notes about the lock. Maximum of 512 characters.
     */
    @JvmName("vjhibcwhnsliodjh")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The owners of the lock.
     */
    @JvmName("coqhmeinkqspnjpo")
    public suspend fun owners(`value`: List<ManagementLockOwnerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owners = mapped
    }

    /**
     * @param argument The owners of the lock.
     */
    @JvmName("dnoebkchifapkhgm")
    public suspend fun owners(argument: List<suspend ManagementLockOwnerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagementLockOwnerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.owners = mapped
    }

    /**
     * @param argument The owners of the lock.
     */
    @JvmName("ebhpgfggwlcgoasw")
    public suspend fun owners(vararg argument: suspend ManagementLockOwnerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagementLockOwnerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.owners = mapped
    }

    /**
     * @param argument The owners of the lock.
     */
    @JvmName("jahfgufumlrossfa")
    public suspend fun owners(argument: suspend ManagementLockOwnerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagementLockOwnerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.owners = mapped
    }

    /**
     * @param values The owners of the lock.
     */
    @JvmName("vtodipphmjrceuod")
    public suspend fun owners(vararg values: ManagementLockOwnerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owners = mapped
    }

    internal fun build(): ManagementLockAtSubscriptionLevelArgs =
        ManagementLockAtSubscriptionLevelArgs(
            level = level,
            lockName = lockName,
            notes = notes,
            owners = owners,
        )
}
