@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicySetDefinitionArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PolicyType
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The policy set definition.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2019-06-01, 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy set definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinition = new AzureNative.Authorization.PolicySetDefinition("policySetDefinition", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Cost Management",
 *         },
 *         Parameters =
 *         {
 *             { "namePrefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 DefaultValue = "myPrefix",
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     DisplayName = "Prefix to enforce on resource names",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.String,
 *             } },
 *         },
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "[parameters('namePrefix')]",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinition(ctx, "policySetDefinition", &authorization.PolicySetDefinitionArgs{
 * 			Description: pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName: pulumi.String("Cost Management"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Cost Management",
 * 			}),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"namePrefix": &authorization.ParameterDefinitionsValueArgs{
 * 					DefaultValue: pulumi.Any("myPrefix"),
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						DisplayName: pulumi.String("Prefix to enforce on resource names"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeString),
 * 				},
 * 			},
 * 			PolicyDefinitions: authorization.PolicyDefinitionReferenceArray{
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"listOfAllowedSKUs": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"prefix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("[parameters('namePrefix')]"),
 * 						},
 * 						"suffix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinition;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionArgs;
 * import com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinition = new PolicySetDefinition("policySetDefinition", PolicySetDefinitionArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .parameters(Map.of("namePrefix", Map.ofEntries(
 *                 Map.entry("defaultValue", "myPrefix"),
 *                 Map.entry("metadata", Map.of("displayName", "Prefix to enforce on resource names")),
 *                 Map.entry("type", "String")
 *             )))
 *             .policyDefinitions(
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .parameters(Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS")))
 *                     .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1")
 *                     .policyDefinitionReferenceId("Limit_Skus")
 *                     .build(),
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .parameters(Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "[parameters('namePrefix')]")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     ))
 *                     .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *                     .policyDefinitionReferenceId("Resource_Naming")
 *                     .build())
 *             .policySetDefinitionName("CostManagement")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy set definition with groups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinition = new AzureNative.Authorization.PolicySetDefinition("policySetDefinition", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Cost Management",
 *         },
 *         PolicyDefinitionGroups = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionGroupArgs
 *             {
 *                 Description = "Policies designed to control spend within a subscription.",
 *                 DisplayName = "Cost Management Policies",
 *                 Name = "CostSaving",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionGroupArgs
 *             {
 *                 Description = "Policies that help enforce resource organization standards within a subscription.",
 *                 DisplayName = "Organizational Policies",
 *                 Name = "Organizational",
 *             },
 *         },
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 GroupNames = new[]
 *                 {
 *                     "CostSaving",
 *                 },
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 GroupNames = new[]
 *                 {
 *                     "Organizational",
 *                 },
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "DeptA",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinition(ctx, "policySetDefinition", &authorization.PolicySetDefinitionArgs{
 * 			Description: pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName: pulumi.String("Cost Management"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Cost Management",
 * 			}),
 * 			PolicyDefinitionGroups: authorization.PolicyDefinitionGroupArray{
 * 				&authorization.PolicyDefinitionGroupArgs{
 * 					Description: pulumi.String("Policies designed to control spend within a subscription."),
 * 					DisplayName: pulumi.String("Cost Management Policies"),
 * 					Name:        pulumi.String("CostSaving"),
 * 				},
 * 				&authorization.PolicyDefinitionGroupArgs{
 * 					Description: pulumi.String("Policies that help enforce resource organization standards within a subscription."),
 * 					DisplayName: pulumi.String("Organizational Policies"),
 * 					Name:        pulumi.String("Organizational"),
 * 				},
 * 			},
 * 			PolicyDefinitions: authorization.PolicyDefinitionReferenceArray{
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					GroupNames: pulumi.StringArray{
 * 						pulumi.String("CostSaving"),
 * 					},
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"listOfAllowedSKUs": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					GroupNames: pulumi.StringArray{
 * 						pulumi.String("Organizational"),
 * 					},
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"prefix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("DeptA"),
 * 						},
 * 						"suffix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinition;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionArgs;
 * import com.pulumi.azurenative.authorization.inputs.PolicyDefinitionGroupArgs;
 * import com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinition = new PolicySetDefinition("policySetDefinition", PolicySetDefinitionArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .policyDefinitionGroups(
 *                 PolicyDefinitionGroupArgs.builder()
 *                     .description("Policies designed to control spend within a subscription.")
 *                     .displayName("Cost Management Policies")
 *                     .name("CostSaving")
 *                     .build(),
 *                 PolicyDefinitionGroupArgs.builder()
 *                     .description("Policies that help enforce resource organization standards within a subscription.")
 *                     .displayName("Organizational Policies")
 *                     .name("Organizational")
 *                     .build())
 *             .policyDefinitions(
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .groupNames("CostSaving")
 *                     .parameters(Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS")))
 *                     .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1")
 *                     .policyDefinitionReferenceId("Limit_Skus")
 *                     .build(),
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .groupNames("Organizational")
 *                     .parameters(Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "DeptA")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     ))
 *                     .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *                     .policyDefinitionReferenceId("Resource_Naming")
 *                     .build())
 *             .policySetDefinitionName("CostManagement")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicySetDefinition CostManagement /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}
 * ```
 * @property description The policy set definition description.
 * @property displayName The display name of the policy set definition.
 * @property metadata The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property parameters The policy set definition parameters that can be used in policy definition references.
 * @property policyDefinitionGroups The metadata describing groups of policy definition references within the policy set definition.
 * @property policyDefinitions An array of policy definition references.
 * @property policySetDefinitionName The name of the policy set definition to create.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 */
public data class PolicySetDefinitionArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null,
    public val policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null,
    public val policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null,
    public val policySetDefinitionName: Output<String>? = null,
    public val policyType: Output<Either<String, PolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.PolicySetDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.PolicySetDefinitionArgs =
        com.pulumi.azurenative.authorization.PolicySetDefinitionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionGroups(
                policyDefinitionGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyDefinitions(
                policyDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .policySetDefinitionName(policySetDefinitionName?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicySetDefinitionArgs].
 */
@PulumiTagMarker
public class PolicySetDefinitionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null

    private var policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null

    private var policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null

    private var policySetDefinitionName: Output<String>? = null

    private var policyType: Output<Either<String, PolicyType>>? = null

    /**
     * @param value The policy set definition description.
     */
    @JvmName("tplpdivcotadnnne")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("lkrfikprgqpisqgi")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("jxceyhtbbmawowww")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("wxkppfjxsdtqvgic")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionsValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("ftuxpmsisxjcdxpf")
    public suspend fun policyDefinitionGroups(`value`: Output<List<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = value
    }

    @JvmName("gyvgptramyrrabia")
    public suspend fun policyDefinitionGroups(vararg values: Output<PolicyDefinitionGroupArgs>) {
        this.policyDefinitionGroups = Output.all(values.asList())
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("ksqjoyptovqejywq")
    public suspend fun policyDefinitionGroups(values: List<Output<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = Output.all(values)
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("fcobwucguvtqchja")
    public suspend fun policyDefinitions(`value`: Output<List<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = value
    }

    @JvmName("lavlfqirbwtqlslk")
    public suspend fun policyDefinitions(vararg values: Output<PolicyDefinitionReferenceArgs>) {
        this.policyDefinitions = Output.all(values.asList())
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("wlhqgbtkmyxlkhkv")
    public suspend fun policyDefinitions(values: List<Output<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = Output.all(values)
    }

    /**
     * @param value The name of the policy set definition to create.
     */
    @JvmName("bgnywnwuoitpuldr")
    public suspend fun policySetDefinitionName(`value`: Output<String>) {
        this.policySetDefinitionName = value
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("fxrhlyndinvjeclb")
    public suspend fun policyType(`value`: Output<Either<String, PolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value The policy set definition description.
     */
    @JvmName("rcfktuwgdppvbirm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("cfraqgbhhwfjwdtt")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("ywqxnmcmqnjywelt")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("pthxcktkvktsnojl")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionsValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("enkyyqjybnhnlqal")
    public suspend fun parameters(vararg argument: Pair<String, suspend ParameterDefinitionsValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionsValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("kcxjxugflqnyjkdv")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionsValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("fngfhmetdmuthkjn")
    public suspend fun policyDefinitionGroups(`value`: List<PolicyDefinitionGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("hbxbfuyiwdrtugba")
    public suspend fun policyDefinitionGroups(argument: List<suspend PolicyDefinitionGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("aefcfnhrtbobcaof")
    public suspend fun policyDefinitionGroups(vararg argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("dsvaryughipkumbv")
    public suspend fun policyDefinitionGroups(argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PolicyDefinitionGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("iedbimmycwhihplq")
    public suspend fun policyDefinitionGroups(vararg values: PolicyDefinitionGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("rhtxrckylccrkpfr")
    public suspend fun policyDefinitions(`value`: List<PolicyDefinitionReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("njfprkmsxyjsmuhg")
    public suspend fun policyDefinitions(argument: List<suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("lykjlpppcwandoxx")
    public suspend fun policyDefinitions(vararg argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("daahjrfcdckivjjr")
    public suspend fun policyDefinitions(argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("yfvrtqylriebldqf")
    public suspend fun policyDefinitions(vararg values: PolicyDefinitionReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param value The name of the policy set definition to create.
     */
    @JvmName("pgbryvxmmsxitkqu")
    public suspend fun policySetDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySetDefinitionName = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("mcvxppykbmupcgjm")
    public suspend fun policyType(`value`: Either<String, PolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("ugimxgfelylyxyxt")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("lkbvuaolicjifgdv")
    public fun policyType(`value`: PolicyType) {
        val toBeMapped = Either.ofRight<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    internal fun build(): PolicySetDefinitionArgs = PolicySetDefinitionArgs(
        description = description,
        displayName = displayName,
        metadata = metadata,
        parameters = parameters,
        policyDefinitionGroups = policyDefinitionGroups,
        policyDefinitions = policyDefinitions,
        policySetDefinitionName = policySetDefinitionName,
        policyType = policyType,
    )
}
