@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RoleAssignment].
 */
@PulumiTagMarker
public class RoleAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleAssignmentArgs = RoleAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleAssignmentArgsBuilder.() -> Unit) {
        val builder = RoleAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RoleAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.RoleAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RoleAssignment(builtJavaResource)
    }
}

/**
 * Role Assignments
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2015-07-01, 2017-10-01-preview, 2020-03-01-preview, 2020-04-01-preview.
 * ## Example Usage
 * ### Create role assignment for resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.Authorization.RoleAssignment("roleAssignment", new()
 *     {
 *         PrincipalId = "ce2ce14e-85d7-4629-bdbc-454d0519d987",
 *         PrincipalType = AzureNative.Authorization.PrincipalType.User,
 *         RoleAssignmentName = "05c5a614-a7d6-4502-b150-c2fb455033ff",
 *         RoleDefinitionId = "/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d",
 *         Scope = "subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg/providers/Microsoft.DocumentDb/databaseAccounts/test-db-account",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleAssignment(ctx, "roleAssignment", &authorization.RoleAssignmentArgs{
 * 			PrincipalId:        pulumi.String("ce2ce14e-85d7-4629-bdbc-454d0519d987"),
 * 			PrincipalType:      pulumi.String(authorization.PrincipalTypeUser),
 * 			RoleAssignmentName: pulumi.String("05c5a614-a7d6-4502-b150-c2fb455033ff"),
 * 			RoleDefinitionId:   pulumi.String("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d"),
 * 			Scope:              pulumi.String("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg/providers/Microsoft.DocumentDb/databaseAccounts/test-db-account"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleAssignment;
 * import com.pulumi.azurenative.authorization.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .principalId("ce2ce14e-85d7-4629-bdbc-454d0519d987")
 *             .principalType("User")
 *             .roleAssignmentName("05c5a614-a7d6-4502-b150-c2fb455033ff")
 *             .roleDefinitionId("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d")
 *             .scope("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg/providers/Microsoft.DocumentDb/databaseAccounts/test-db-account")
 *             .build());
 *     }
 * }
 * ```
 * ### Create role assignment for resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.Authorization.RoleAssignment("roleAssignment", new()
 *     {
 *         PrincipalId = "ce2ce14e-85d7-4629-bdbc-454d0519d987",
 *         PrincipalType = AzureNative.Authorization.PrincipalType.User,
 *         RoleAssignmentName = "05c5a614-a7d6-4502-b150-c2fb455033ff",
 *         RoleDefinitionId = "/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d",
 *         Scope = "subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleAssignment(ctx, "roleAssignment", &authorization.RoleAssignmentArgs{
 * 			PrincipalId:        pulumi.String("ce2ce14e-85d7-4629-bdbc-454d0519d987"),
 * 			PrincipalType:      pulumi.String(authorization.PrincipalTypeUser),
 * 			RoleAssignmentName: pulumi.String("05c5a614-a7d6-4502-b150-c2fb455033ff"),
 * 			RoleDefinitionId:   pulumi.String("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d"),
 * 			Scope:              pulumi.String("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleAssignment;
 * import com.pulumi.azurenative.authorization.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .principalId("ce2ce14e-85d7-4629-bdbc-454d0519d987")
 *             .principalType("User")
 *             .roleAssignmentName("05c5a614-a7d6-4502-b150-c2fb455033ff")
 *             .roleDefinitionId("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d")
 *             .scope("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create role assignment for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.Authorization.RoleAssignment("roleAssignment", new()
 *     {
 *         PrincipalId = "ce2ce14e-85d7-4629-bdbc-454d0519d987",
 *         PrincipalType = AzureNative.Authorization.PrincipalType.User,
 *         RoleAssignmentName = "05c5a614-a7d6-4502-b150-c2fb455033ff",
 *         RoleDefinitionId = "/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d",
 *         Scope = "subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleAssignment(ctx, "roleAssignment", &authorization.RoleAssignmentArgs{
 * 			PrincipalId:        pulumi.String("ce2ce14e-85d7-4629-bdbc-454d0519d987"),
 * 			PrincipalType:      pulumi.String(authorization.PrincipalTypeUser),
 * 			RoleAssignmentName: pulumi.String("05c5a614-a7d6-4502-b150-c2fb455033ff"),
 * 			RoleDefinitionId:   pulumi.String("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d"),
 * 			Scope:              pulumi.String("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleAssignment;
 * import com.pulumi.azurenative.authorization.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .principalId("ce2ce14e-85d7-4629-bdbc-454d0519d987")
 *             .principalType("User")
 *             .roleAssignmentName("05c5a614-a7d6-4502-b150-c2fb455033ff")
 *             .roleDefinitionId("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d")
 *             .scope("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:RoleAssignment 05c5a614-a7d6-4502-b150-c2fb455033ff /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}
 * ```
 */
public class RoleAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.RoleAssignment,
) : KotlinCustomResource(javaResource, RoleAssignmentMapper) {
    /**
     * The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft&#46;Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
     */
    public val condition: Output<String>?
        get() = javaResource.condition().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Version of the condition. Currently the only accepted value is '2.0'
     */
    public val conditionVersion: Output<String>?
        get() = javaResource.conditionVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Id of the user who created the assignment
     */
    public val createdBy: Output<String>
        get() = javaResource.createdBy().applyValue({ args0 -> args0 })

    /**
     * Time it was created
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Id of the delegated managed identity resource
     */
    public val delegatedManagedIdentityResourceId: Output<String>?
        get() = javaResource.delegatedManagedIdentityResourceId().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Description of role assignment
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The role assignment name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principal ID.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The principal type of the assigned principal ID.
     */
    public val principalType: Output<String>?
        get() = javaResource.principalType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The role definition ID.
     */
    public val roleDefinitionId: Output<String>
        get() = javaResource.roleDefinitionId().applyValue({ args0 -> args0 })

    /**
     * The role assignment scope.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * The role assignment type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Id of the user who updated the assignment
     */
    public val updatedBy: Output<String>
        get() = javaResource.updatedBy().applyValue({ args0 -> args0 })

    /**
     * Time it was updated
     */
    public val updatedOn: Output<String>
        get() = javaResource.updatedOn().applyValue({ args0 -> args0 })
}

public object RoleAssignmentMapper : ResourceMapper<RoleAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.RoleAssignment::class == javaResource::class

    override fun map(javaResource: Resource): RoleAssignment = RoleAssignment(
        javaResource as
            com.pulumi.azurenative.authorization.RoleAssignment,
    )
}

/**
 * @see [RoleAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleAssignment].
 */
public suspend fun roleAssignment(
    name: String,
    block: suspend RoleAssignmentResourceBuilder.() -> Unit,
): RoleAssignment {
    val builder = RoleAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleAssignment(name: String): RoleAssignment {
    val builder = RoleAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
