@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.RoleAssignmentArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Role Assignments
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2020-10-01-preview.
 * Other available API versions: 2015-07-01, 2017-10-01-preview, 2020-03-01-preview, 2020-04-01-preview.
 * ## Example Usage
 * ### Create role assignment for resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.Authorization.RoleAssignment("roleAssignment", new()
 *     {
 *         PrincipalId = "ce2ce14e-85d7-4629-bdbc-454d0519d987",
 *         PrincipalType = AzureNative.Authorization.PrincipalType.User,
 *         RoleAssignmentName = "05c5a614-a7d6-4502-b150-c2fb455033ff",
 *         RoleDefinitionId = "/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d",
 *         Scope = "subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg/providers/Microsoft.DocumentDb/databaseAccounts/test-db-account",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleAssignment(ctx, "roleAssignment", &authorization.RoleAssignmentArgs{
 * 			PrincipalId:        pulumi.String("ce2ce14e-85d7-4629-bdbc-454d0519d987"),
 * 			PrincipalType:      pulumi.String(authorization.PrincipalTypeUser),
 * 			RoleAssignmentName: pulumi.String("05c5a614-a7d6-4502-b150-c2fb455033ff"),
 * 			RoleDefinitionId:   pulumi.String("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d"),
 * 			Scope:              pulumi.String("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg/providers/Microsoft.DocumentDb/databaseAccounts/test-db-account"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleAssignment;
 * import com.pulumi.azurenative.authorization.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .principalId("ce2ce14e-85d7-4629-bdbc-454d0519d987")
 *             .principalType("User")
 *             .roleAssignmentName("05c5a614-a7d6-4502-b150-c2fb455033ff")
 *             .roleDefinitionId("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d")
 *             .scope("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg/providers/Microsoft.DocumentDb/databaseAccounts/test-db-account")
 *             .build());
 *     }
 * }
 * ```
 * ### Create role assignment for resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.Authorization.RoleAssignment("roleAssignment", new()
 *     {
 *         PrincipalId = "ce2ce14e-85d7-4629-bdbc-454d0519d987",
 *         PrincipalType = AzureNative.Authorization.PrincipalType.User,
 *         RoleAssignmentName = "05c5a614-a7d6-4502-b150-c2fb455033ff",
 *         RoleDefinitionId = "/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d",
 *         Scope = "subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleAssignment(ctx, "roleAssignment", &authorization.RoleAssignmentArgs{
 * 			PrincipalId:        pulumi.String("ce2ce14e-85d7-4629-bdbc-454d0519d987"),
 * 			PrincipalType:      pulumi.String(authorization.PrincipalTypeUser),
 * 			RoleAssignmentName: pulumi.String("05c5a614-a7d6-4502-b150-c2fb455033ff"),
 * 			RoleDefinitionId:   pulumi.String("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d"),
 * 			Scope:              pulumi.String("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleAssignment;
 * import com.pulumi.azurenative.authorization.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .principalId("ce2ce14e-85d7-4629-bdbc-454d0519d987")
 *             .principalType("User")
 *             .roleAssignmentName("05c5a614-a7d6-4502-b150-c2fb455033ff")
 *             .roleDefinitionId("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d")
 *             .scope("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/resourceGroups/testrg")
 *             .build());
 *     }
 * }
 * ```
 * ### Create role assignment for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleAssignment = new AzureNative.Authorization.RoleAssignment("roleAssignment", new()
 *     {
 *         PrincipalId = "ce2ce14e-85d7-4629-bdbc-454d0519d987",
 *         PrincipalType = AzureNative.Authorization.PrincipalType.User,
 *         RoleAssignmentName = "05c5a614-a7d6-4502-b150-c2fb455033ff",
 *         RoleDefinitionId = "/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d",
 *         Scope = "subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleAssignment(ctx, "roleAssignment", &authorization.RoleAssignmentArgs{
 * 			PrincipalId:        pulumi.String("ce2ce14e-85d7-4629-bdbc-454d0519d987"),
 * 			PrincipalType:      pulumi.String(authorization.PrincipalTypeUser),
 * 			RoleAssignmentName: pulumi.String("05c5a614-a7d6-4502-b150-c2fb455033ff"),
 * 			RoleDefinitionId:   pulumi.String("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d"),
 * 			Scope:              pulumi.String("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleAssignment;
 * import com.pulumi.azurenative.authorization.RoleAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleAssignment = new RoleAssignment("roleAssignment", RoleAssignmentArgs.builder()
 *             .principalId("ce2ce14e-85d7-4629-bdbc-454d0519d987")
 *             .principalType("User")
 *             .roleAssignmentName("05c5a614-a7d6-4502-b150-c2fb455033ff")
 *             .roleDefinitionId("/subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2/providers/Microsoft.Authorization/roleDefinitions/0b5fe924-9a61-425c-96af-cfe6e287ca2d")
 *             .scope("subscriptions/a925f2f7-5c63-4b7b-8799-25a5f97bc3b2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:RoleAssignment 05c5a614-a7d6-4502-b150-c2fb455033ff /{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}
 * ```
 * @property condition The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft&#46;Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
 * @property conditionVersion Version of the condition. Currently the only accepted value is '2.0'
 * @property delegatedManagedIdentityResourceId Id of the delegated managed identity resource
 * @property description Description of role assignment
 * @property principalId The principal ID.
 * @property principalType The principal type of the assigned principal ID.
 * @property roleAssignmentName The name of the role assignment. It can be any valid GUID.
 * @property roleDefinitionId The role definition ID.
 * @property scope The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 */
public data class RoleAssignmentArgs(
    public val condition: Output<String>? = null,
    public val conditionVersion: Output<String>? = null,
    public val delegatedManagedIdentityResourceId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalType: Output<Either<String, PrincipalType>>? = null,
    public val roleAssignmentName: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.RoleAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.RoleAssignmentArgs =
        com.pulumi.azurenative.authorization.RoleAssignmentArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0 }))
            .conditionVersion(conditionVersion?.applyValue({ args0 -> args0 }))
            .delegatedManagedIdentityResourceId(
                delegatedManagedIdentityResourceId?.applyValue({ args0 ->
                    args0
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalType(
                principalType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .roleAssignmentName(roleAssignmentName?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleAssignmentArgs].
 */
@PulumiTagMarker
public class RoleAssignmentArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var conditionVersion: Output<String>? = null

    private var delegatedManagedIdentityResourceId: Output<String>? = null

    private var description: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalType: Output<Either<String, PrincipalType>>? = null

    private var roleAssignmentName: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft&#46;Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
     */
    @JvmName("pohxrmlalujojxhy")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value Version of the condition. Currently the only accepted value is '2.0'
     */
    @JvmName("eicdxusmwmyahslu")
    public suspend fun conditionVersion(`value`: Output<String>) {
        this.conditionVersion = value
    }

    /**
     * @param value Id of the delegated managed identity resource
     */
    @JvmName("mlnotoivteevdlyt")
    public suspend fun delegatedManagedIdentityResourceId(`value`: Output<String>) {
        this.delegatedManagedIdentityResourceId = value
    }

    /**
     * @param value Description of role assignment
     */
    @JvmName("mubtwngcepjtiqcp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The principal ID.
     */
    @JvmName("axpflhwofejaecho")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The principal type of the assigned principal ID.
     */
    @JvmName("ohupufjcxxbnwuck")
    public suspend fun principalType(`value`: Output<Either<String, PrincipalType>>) {
        this.principalType = value
    }

    /**
     * @param value The name of the role assignment. It can be any valid GUID.
     */
    @JvmName("ygrhakkkecuiwdus")
    public suspend fun roleAssignmentName(`value`: Output<String>) {
        this.roleAssignmentName = value
    }

    /**
     * @param value The role definition ID.
     */
    @JvmName("hcstilccleojhsws")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("kjsjcjcwuhwwvihq")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft&#46;Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
     */
    @JvmName("nthgakdmopxqqoel")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value Version of the condition. Currently the only accepted value is '2.0'
     */
    @JvmName("gmfpyjpricsurmqn")
    public suspend fun conditionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditionVersion = mapped
    }

    /**
     * @param value Id of the delegated managed identity resource
     */
    @JvmName("sdntrfednphdvgop")
    public suspend fun delegatedManagedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedManagedIdentityResourceId = mapped
    }

    /**
     * @param value Description of role assignment
     */
    @JvmName("kcceedwjbwjamtum")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The principal ID.
     */
    @JvmName("xjhjteehthbmyfmq")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The principal type of the assigned principal ID.
     */
    @JvmName("yajjchersdvlgxoy")
    public suspend fun principalType(`value`: Either<String, PrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The principal type of the assigned principal ID.
     */
    @JvmName("dpbktdjjkdypigxm")
    public fun principalType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The principal type of the assigned principal ID.
     */
    @JvmName("ptypnfmnycpvmchd")
    public fun principalType(`value`: PrincipalType) {
        val toBeMapped = Either.ofRight<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The name of the role assignment. It can be any valid GUID.
     */
    @JvmName("mlsduwlyegpvsevn")
    public suspend fun roleAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleAssignmentName = mapped
    }

    /**
     * @param value The role definition ID.
     */
    @JvmName("cvmqutbbieljwblq")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("efvsvsochxnjsykr")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): RoleAssignmentArgs = RoleAssignmentArgs(
        condition = condition,
        conditionVersion = conditionVersion,
        delegatedManagedIdentityResourceId = delegatedManagedIdentityResourceId,
        description = description,
        principalId = principalId,
        principalType = principalType,
        roleAssignmentName = roleAssignmentName,
        roleDefinitionId = roleDefinitionId,
        scope = scope,
    )
}
