@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The option whether validate the exemption is at or under the assignment scope.
 */
public enum class AssignmentScopeValidation(
    public val javaValue: com.pulumi.azurenative.authorization.enums.AssignmentScopeValidation,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.AssignmentScopeValidation> {
    /**
     * This option will validate the exemption is at or under the assignment scope.
     */
    Default(com.pulumi.azurenative.authorization.enums.AssignmentScopeValidation.Default),

    /**
     * This option will bypass the validation the exemption scope is at or under the policy assignment scope.
     */
    DoNotValidate(com.pulumi.azurenative.authorization.enums.AssignmentScopeValidation.DoNotValidate),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.AssignmentScopeValidation =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.AssignmentScopeValidation): AssignmentScopeValidation =
            AssignmentScopeValidation.values().first { it.javaValue == javaType }
    }
}
