@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The policy exemption category. Possible values are Waiver and Mitigated.
 */
public enum class ExemptionCategory(
    public val javaValue: com.pulumi.azurenative.authorization.enums.ExemptionCategory,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.ExemptionCategory> {
    /**
     * This category of exemptions usually means the scope is not applicable for the policy.
     */
    Waiver(com.pulumi.azurenative.authorization.enums.ExemptionCategory.Waiver),

    /**
     * This category of exemptions usually means the mitigation actions have been applied to the scope.
     */
    Mitigated(com.pulumi.azurenative.authorization.enums.ExemptionCategory.Mitigated),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.ExemptionCategory = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.ExemptionCategory): ExemptionCategory = ExemptionCategory.values().first { it.javaValue == javaType }
    }
}
