@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The data type of the parameter.
 */
public enum class ParameterType(
    public val javaValue: com.pulumi.azurenative.authorization.enums.ParameterType,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.ParameterType> {
    String(com.pulumi.azurenative.authorization.enums.ParameterType.String),
    Array(com.pulumi.azurenative.authorization.enums.ParameterType.Array),
    Object(com.pulumi.azurenative.authorization.enums.ParameterType.Object),
    Boolean(com.pulumi.azurenative.authorization.enums.ParameterType.Boolean),
    Integer(com.pulumi.azurenative.authorization.enums.ParameterType.Integer),
    Float(com.pulumi.azurenative.authorization.enums.ParameterType.Float),
    DateTime(com.pulumi.azurenative.authorization.enums.ParameterType.DateTime),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.ParameterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.ParameterType): ParameterType = ParameterType.values().first { it.javaValue == javaType }
    }
}
