@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 */
public enum class PolicyType(
    public val javaValue: com.pulumi.azurenative.authorization.enums.PolicyType,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.PolicyType> {
    NotSpecified(com.pulumi.azurenative.authorization.enums.PolicyType.NotSpecified),
    BuiltIn(com.pulumi.azurenative.authorization.enums.PolicyType.BuiltIn),
    Custom(com.pulumi.azurenative.authorization.enums.PolicyType.Custom),
    Static(com.pulumi.azurenative.authorization.enums.PolicyType.Static),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.PolicyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.PolicyType): PolicyType = PolicyType.values().first { it.javaValue == javaType }
    }
}
