@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The principal type of the assigned principal ID.
 */
public enum class PrincipalType(
    public val javaValue: com.pulumi.azurenative.authorization.enums.PrincipalType,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.PrincipalType> {
    User(com.pulumi.azurenative.authorization.enums.PrincipalType.User),
    Group(com.pulumi.azurenative.authorization.enums.PrincipalType.Group),
    ServicePrincipal(com.pulumi.azurenative.authorization.enums.PrincipalType.ServicePrincipal),
    ForeignGroup(com.pulumi.azurenative.authorization.enums.PrincipalType.ForeignGroup),
    Device(com.pulumi.azurenative.authorization.enums.PrincipalType.Device),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.PrincipalType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.PrincipalType): PrincipalType = PrincipalType.values().first { it.javaValue == javaType }
    }
}
