@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The identity type. This is the only required field when adding a system or user assigned identity to a resource.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.authorization.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.enums.ResourceIdentityType> {
    /**
     * Indicates that a system assigned identity is associated with the resource.
     */
    SystemAssigned(com.pulumi.azurenative.authorization.enums.ResourceIdentityType.SystemAssigned),

    /**
     * Indicates that a system assigned identity is associated with the resource.
     */
    UserAssigned(com.pulumi.azurenative.authorization.enums.ResourceIdentityType.UserAssigned),

    /**
     * Indicates that no identity is associated with the resource or that the existing identity should be removed.
     */
    None(com.pulumi.azurenative.authorization.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.authorization.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
