@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.AccessReviewHistoryInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Access Review History Definition Instance.
 * @property displayName The display name for the parent history definition.
 * @property expiration Date time when history data report expires and the associated data is deleted.
 * @property fulfilledDateTime Date time when the history data report is scheduled to be generated.
 * @property reviewHistoryPeriodEndDateTime Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
 * @property reviewHistoryPeriodStartDateTime Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
 * @property runDateTime Date time when the history data report is scheduled to be generated.
 */
public data class AccessReviewHistoryInstanceArgs(
    public val displayName: Output<String>? = null,
    public val expiration: Output<String>? = null,
    public val fulfilledDateTime: Output<String>? = null,
    public val reviewHistoryPeriodEndDateTime: Output<String>? = null,
    public val reviewHistoryPeriodStartDateTime: Output<String>? = null,
    public val runDateTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.AccessReviewHistoryInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.AccessReviewHistoryInstanceArgs = com.pulumi.azurenative.authorization.inputs.AccessReviewHistoryInstanceArgs.builder()
        .displayName(displayName?.applyValue({ args0 -> args0 }))
        .expiration(expiration?.applyValue({ args0 -> args0 }))
        .fulfilledDateTime(fulfilledDateTime?.applyValue({ args0 -> args0 }))
        .reviewHistoryPeriodEndDateTime(reviewHistoryPeriodEndDateTime?.applyValue({ args0 -> args0 }))
        .reviewHistoryPeriodStartDateTime(reviewHistoryPeriodStartDateTime?.applyValue({ args0 -> args0 }))
        .runDateTime(runDateTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessReviewHistoryInstanceArgs].
 */
@PulumiTagMarker
public class AccessReviewHistoryInstanceArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var expiration: Output<String>? = null

    private var fulfilledDateTime: Output<String>? = null

    private var reviewHistoryPeriodEndDateTime: Output<String>? = null

    private var reviewHistoryPeriodStartDateTime: Output<String>? = null

    private var runDateTime: Output<String>? = null

    /**
     * @param value The display name for the parent history definition.
     */
    @JvmName("vrgsciuccvdcrasf")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Date time when history data report expires and the associated data is deleted.
     */
    @JvmName("amniajqoanklyanm")
    public suspend fun expiration(`value`: Output<String>) {
        this.expiration = value
    }

    /**
     * @param value Date time when the history data report is scheduled to be generated.
     */
    @JvmName("onpbtkhtytnnrapn")
    public suspend fun fulfilledDateTime(`value`: Output<String>) {
        this.fulfilledDateTime = value
    }

    /**
     * @param value Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
     */
    @JvmName("hdhqsubfmmoiwemo")
    public suspend fun reviewHistoryPeriodEndDateTime(`value`: Output<String>) {
        this.reviewHistoryPeriodEndDateTime = value
    }

    /**
     * @param value Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
     */
    @JvmName("bybwbdvqfvycjckc")
    public suspend fun reviewHistoryPeriodStartDateTime(`value`: Output<String>) {
        this.reviewHistoryPeriodStartDateTime = value
    }

    /**
     * @param value Date time when the history data report is scheduled to be generated.
     */
    @JvmName("jlffcxagjwtpfyvy")
    public suspend fun runDateTime(`value`: Output<String>) {
        this.runDateTime = value
    }

    /**
     * @param value The display name for the parent history definition.
     */
    @JvmName("gfvkobjvksckpquj")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Date time when history data report expires and the associated data is deleted.
     */
    @JvmName("xjuhsffcukbqrkne")
    public suspend fun expiration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param value Date time when the history data report is scheduled to be generated.
     */
    @JvmName("nmumjesrkotgwdjo")
    public suspend fun fulfilledDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfilledDateTime = mapped
    }

    /**
     * @param value Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
     */
    @JvmName("uxpvktxdlivpiklm")
    public suspend fun reviewHistoryPeriodEndDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reviewHistoryPeriodEndDateTime = mapped
    }

    /**
     * @param value Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
     */
    @JvmName("joeupmrgdxbvplxv")
    public suspend fun reviewHistoryPeriodStartDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reviewHistoryPeriodStartDateTime = mapped
    }

    /**
     * @param value Date time when the history data report is scheduled to be generated.
     */
    @JvmName("vpipbquqbeatpple")
    public suspend fun runDateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runDateTime = mapped
    }

    internal fun build(): AccessReviewHistoryInstanceArgs = AccessReviewHistoryInstanceArgs(
        displayName = displayName,
        expiration = expiration,
        fulfilledDateTime = fulfilledDateTime,
        reviewHistoryPeriodEndDateTime = reviewHistoryPeriodEndDateTime,
        reviewHistoryPeriodStartDateTime = reviewHistoryPeriodStartDateTime,
        runDateTime = runDateTime,
    )
}
