@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetManagementLockByScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lockName The name of lock.
 * @property scope The scope for the lock.
 */
public data class GetManagementLockByScopePlainArgs(
    public val lockName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetManagementLockByScopePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetManagementLockByScopePlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetManagementLockByScopePlainArgs.builder()
            .lockName(lockName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementLockByScopePlainArgs].
 */
@PulumiTagMarker
public class GetManagementLockByScopePlainArgsBuilder internal constructor() {
    private var lockName: String? = null

    private var scope: String? = null

    /**
     * @param value The name of lock.
     */
    @JvmName("qkcxfapmqxpcqwpq")
    public suspend fun lockName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lockName = mapped
    }

    /**
     * @param value The scope for the lock.
     */
    @JvmName("jjvgmdqooxhgydwg")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetManagementLockByScopePlainArgs = GetManagementLockByScopePlainArgs(
        lockName = lockName ?: throw PulumiNullFieldException("lockName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
