@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyDefinitionName The name of the policy definition.
 * @property policyDefinitionVersion The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
 */
public data class GetPolicyDefinitionVersionPlainArgs(
    public val policyDefinitionName: String,
    public val policyDefinitionVersion: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionPlainArgs.builder()
            .policyDefinitionName(policyDefinitionName.let({ args0 -> args0 }))
            .policyDefinitionVersion(policyDefinitionVersion.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDefinitionVersionPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyDefinitionVersionPlainArgsBuilder internal constructor() {
    private var policyDefinitionName: String? = null

    private var policyDefinitionVersion: String? = null

    /**
     * @param value The name of the policy definition.
     */
    @JvmName("afshdulbidasbcnm")
    public suspend fun policyDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionName = mapped
    }

    /**
     * @param value The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("aeikdbwwegbvokka")
    public suspend fun policyDefinitionVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionVersion = mapped
    }

    internal fun build(): GetPolicyDefinitionVersionPlainArgs = GetPolicyDefinitionVersionPlainArgs(
        policyDefinitionName = policyDefinitionName ?: throw
            PulumiNullFieldException("policyDefinitionName"),
        policyDefinitionVersion = policyDefinitionVersion ?: throw
            PulumiNullFieldException("policyDefinitionVersion"),
    )
}
