@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicyExemptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyExemptionName The name of the policy exemption to delete.
 * @property scope The scope of the policy exemption. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 */
public data class GetPolicyExemptionPlainArgs(
    public val policyExemptionName: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicyExemptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetPolicyExemptionPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicyExemptionPlainArgs.builder()
            .policyExemptionName(policyExemptionName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyExemptionPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyExemptionPlainArgsBuilder internal constructor() {
    private var policyExemptionName: String? = null

    private var scope: String? = null

    /**
     * @param value The name of the policy exemption to delete.
     */
    @JvmName("usbpsatvspxmneaj")
    public suspend fun policyExemptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyExemptionName = mapped
    }

    /**
     * @param value The scope of the policy exemption. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("nsjbibhcocxjcjok")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetPolicyExemptionPlainArgs = GetPolicyExemptionPlainArgs(
        policyExemptionName = policyExemptionName ?: throw PulumiNullFieldException("policyExemptionName"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
