@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetResourceManagementPrivateLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property rmplName The name of the resource management private link.
 */
public data class GetResourceManagementPrivateLinkPlainArgs(
    public val resourceGroupName: String,
    public val rmplName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetResourceManagementPrivateLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetResourceManagementPrivateLinkPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetResourceManagementPrivateLinkPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .rmplName(rmplName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceManagementPrivateLinkPlainArgs].
 */
@PulumiTagMarker
public class GetResourceManagementPrivateLinkPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var rmplName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lcgdjegwjgxhiugg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource management private link.
     */
    @JvmName("byoinmvjhwxarjuk")
    public suspend fun rmplName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rmplName = mapped
    }

    internal fun build(): GetResourceManagementPrivateLinkPlainArgs =
        GetResourceManagementPrivateLinkPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            rmplName = rmplName ?: throw PulumiNullFieldException("rmplName"),
        )
}
