@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetRoleManagementPolicyAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to get.
 * @property scope The scope of the role management policy.
 */
public data class GetRoleManagementPolicyAssignmentPlainArgs(
    public val roleManagementPolicyAssignmentName: String,
    public val scope: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetRoleManagementPolicyAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetRoleManagementPolicyAssignmentPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetRoleManagementPolicyAssignmentPlainArgs.builder()
            .roleManagementPolicyAssignmentName(roleManagementPolicyAssignmentName.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoleManagementPolicyAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetRoleManagementPolicyAssignmentPlainArgsBuilder internal constructor() {
    private var roleManagementPolicyAssignmentName: String? = null

    private var scope: String? = null

    /**
     * @param value The name of format {guid_guid} the role management policy assignment to get.
     */
    @JvmName("aeimrgjkohdrqibp")
    public suspend fun roleManagementPolicyAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleManagementPolicyAssignmentName = mapped
    }

    /**
     * @param value The scope of the role management policy.
     */
    @JvmName("bkayduwcrlpkjdwq")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetRoleManagementPolicyAssignmentPlainArgs =
        GetRoleManagementPolicyAssignmentPlainArgs(
            roleManagementPolicyAssignmentName = roleManagementPolicyAssignmentName ?: throw
                PulumiNullFieldException("roleManagementPolicyAssignmentName"),
            scope = scope ?: throw PulumiNullFieldException("scope"),
        )
}
