@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetVariableAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId The ID of the management group.
 * @property variableName The name of the variable to operate on.
 */
public data class GetVariableAtManagementGroupPlainArgs(
    public val managementGroupId: String,
    public val variableName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetVariableAtManagementGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetVariableAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetVariableAtManagementGroupPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .variableName(variableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVariableAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetVariableAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var variableName: String? = null

    /**
     * @param value The ID of the management group.
     */
    @JvmName("cyngyglvrqhbcowl")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("mymjgqntsqpixywo")
    public suspend fun variableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variableName = mapped
    }

    internal fun build(): GetVariableAtManagementGroupPlainArgs =
        GetVariableAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            variableName = variableName ?: throw PulumiNullFieldException("variableName"),
        )
}
