@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.PolicyVariableValueColumnValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The name value tuple for this variable value column.
 * @property columnName Column name for the variable value
 * @property columnValue Column value for the variable value; this can be an integer, double, boolean, null or a string.
 */
public data class PolicyVariableValueColumnValueArgs(
    public val columnName: Output<String>,
    public val columnValue: Output<Any>,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.PolicyVariableValueColumnValueArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.PolicyVariableValueColumnValueArgs =
        com.pulumi.azurenative.authorization.inputs.PolicyVariableValueColumnValueArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .columnValue(columnValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyVariableValueColumnValueArgs].
 */
@PulumiTagMarker
public class PolicyVariableValueColumnValueArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var columnValue: Output<Any>? = null

    /**
     * @param value Column name for the variable value
     */
    @JvmName("bqvpknlitnjphmoa")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value Column value for the variable value; this can be an integer, double, boolean, null or a string.
     */
    @JvmName("dgmvpqrvvtqysesa")
    public suspend fun columnValue(`value`: Output<Any>) {
        this.columnValue = value
    }

    /**
     * @param value Column name for the variable value
     */
    @JvmName("yoxtiqjvkvjkpaia")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value Column value for the variable value; this can be an integer, double, boolean, null or a string.
     */
    @JvmName("fvdbhrjqijtlbqsl")
    public suspend fun columnValue(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnValue = mapped
    }

    internal fun build(): PolicyVariableValueColumnValueArgs = PolicyVariableValueColumnValueArgs(
        columnName = columnName ?: throw PulumiNullFieldException("columnName"),
        columnValue = columnValue ?: throw PulumiNullFieldException("columnValue"),
    )
}
