@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Access Review History Definition Instance.
 * @property displayName The display name for the parent history definition.
 * @property downloadUri Uri which can be used to retrieve review history data. To generate this Uri, generateDownloadUri() must be called for a specific accessReviewHistoryDefinitionInstance. The link expires after a 24 hour period. Callers can see the expiration date time by looking at the 'se' parameter in the generated uri.
 * @property expiration Date time when history data report expires and the associated data is deleted.
 * @property fulfilledDateTime Date time when the history data report is scheduled to be generated.
 * @property id The access review history definition instance id.
 * @property name The access review history definition instance unique id.
 * @property reviewHistoryPeriodEndDateTime Date time used when selecting review data, all reviews included in data end on or before this date. For use only with one-time/non-recurring reports.
 * @property reviewHistoryPeriodStartDateTime Date time used when selecting review data, all reviews included in data start on or after this date. For use only with one-time/non-recurring reports.
 * @property runDateTime Date time when the history data report is scheduled to be generated.
 * @property status Status of the requested review history instance data. This is either requested, in-progress, done or error. The state transitions are as follows - Requested -> InProgress -> Done -> Expired
 * @property type The resource type.
 */
public data class AccessReviewHistoryInstanceResponse(
    public val displayName: String? = null,
    public val downloadUri: String,
    public val expiration: String? = null,
    public val fulfilledDateTime: String? = null,
    public val id: String,
    public val name: String,
    public val reviewHistoryPeriodEndDateTime: String? = null,
    public val reviewHistoryPeriodStartDateTime: String? = null,
    public val runDateTime: String? = null,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.AccessReviewHistoryInstanceResponse): AccessReviewHistoryInstanceResponse = AccessReviewHistoryInstanceResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            downloadUri = javaType.downloadUri(),
            expiration = javaType.expiration().map({ args0 -> args0 }).orElse(null),
            fulfilledDateTime = javaType.fulfilledDateTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            reviewHistoryPeriodEndDateTime = javaType.reviewHistoryPeriodEndDateTime().map({ args0 ->
                args0
            }).orElse(null),
            reviewHistoryPeriodStartDateTime = javaType.reviewHistoryPeriodStartDateTime().map({ args0 ->
                args0
            }).orElse(null),
            runDateTime = javaType.runDateTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
