@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Descriptor for what needs to be reviewed
 * @property principalId The id of the reviewer(user/servicePrincipal)
 * @property principalType The identity type : user/servicePrincipal
 */
public data class AccessReviewReviewerResponse(
    public val principalId: String? = null,
    public val principalType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.AccessReviewReviewerResponse): AccessReviewReviewerResponse = AccessReviewReviewerResponse(
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            principalType = javaType.principalType(),
        )
    }
}
