@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The approval settings.
 * @property approvalMode The type of rule
 * @property approvalStages The approval stages of the request.
 * @property isApprovalRequired Determines whether approval is required or not.
 * @property isApprovalRequiredForExtension Determines whether approval is required for assignment extension.
 * @property isRequestorJustificationRequired Determine whether requestor justification is required.
 */
public data class ApprovalSettingsResponse(
    public val approvalMode: String? = null,
    public val approvalStages: List<ApprovalStageResponse>? = null,
    public val isApprovalRequired: Boolean? = null,
    public val isApprovalRequiredForExtension: Boolean? = null,
    public val isRequestorJustificationRequired: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.ApprovalSettingsResponse): ApprovalSettingsResponse = ApprovalSettingsResponse(
            approvalMode = javaType.approvalMode().map({ args0 -> args0 }).orElse(null),
            approvalStages = javaType.approvalStages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.ApprovalStageResponse.Companion.toKotlin(args0)
                })
            }),
            isApprovalRequired = javaType.isApprovalRequired().map({ args0 -> args0 }).orElse(null),
            isApprovalRequiredForExtension = javaType.isApprovalRequiredForExtension().map({ args0 ->
                args0
            }).orElse(null),
            isRequestorJustificationRequired = javaType.isRequestorJustificationRequired().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
