@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration values returned by getClientConfig.
 * @property clientId Azure Client ID (Application Object ID).
 * @property objectId Azure Object ID of the current user or service principal.
 * @property subscriptionId Azure Subscription ID
 * @property tenantId Azure Tenant ID
 */
public data class GetClientConfigResult(
    public val clientId: String,
    public val objectId: String,
    public val subscriptionId: String,
    public val tenantId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetClientConfigResult): GetClientConfigResult = GetClientConfigResult(
            clientId = javaType.clientId(),
            objectId = javaType.objectId(),
            subscriptionId = javaType.subscriptionId(),
            tenantId = javaType.tenantId(),
        )
    }
}
