@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The policy assignment.
 * @property description This message will be part of response in case of policy violation.
 * @property displayName The display name of the policy assignment.
 * @property enforcementMode The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
 * @property id The ID of the policy assignment.
 * @property identity The managed identity associated with the policy assignment.
 * @property location The location of the policy assignment. Only required when utilizing managed identity.
 * @property metadata The policy assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
 * @property name The name of the policy assignment.
 * @property nonComplianceMessages The messages that describe why a resource is non-compliant with the policy.
 * @property notScopes The policy's excluded scopes.
 * @property overrides The policy property value override.
 * @property parameters The parameter values for the assigned policy rule. The keys are the parameter names.
 * @property policyDefinitionId The ID of the policy definition or policy set definition being assigned.
 * @property resourceSelectors The resource selector list to filter policies by resource properties.
 * @property scope The scope for the policy assignment.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the policy assignment.
 */
public data class GetPolicyAssignmentResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val enforcementMode: String? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String? = null,
    public val metadata: Any? = null,
    public val name: String,
    public val nonComplianceMessages: List<NonComplianceMessageResponse>? = null,
    public val notScopes: List<String>? = null,
    public val overrides: List<OverrideResponse>? = null,
    public val parameters: Map<String, ParameterValuesValueResponse>? = null,
    public val policyDefinitionId: String? = null,
    public val resourceSelectors: List<ResourceSelectorResponse>? = null,
    public val scope: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetPolicyAssignmentResult): GetPolicyAssignmentResult = GetPolicyAssignmentResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            enforcementMode = javaType.enforcementMode().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nonComplianceMessages = javaType.nonComplianceMessages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.NonComplianceMessageResponse.Companion.toKotlin(args0)
                })
            }),
            notScopes = javaType.notScopes().map({ args0 -> args0 }),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.OverrideResponse.Companion.toKotlin(args0)
                })
            }),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.ParameterValuesValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            policyDefinitionId = javaType.policyDefinitionId().map({ args0 -> args0 }).orElse(null),
            resourceSelectors = javaType.resourceSelectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.ResourceSelectorResponse.Companion.toKotlin(args0)
                })
            }),
            scope = javaType.scope(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
