@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The policy definition.
 * @property description The policy definition description.
 * @property displayName The display name of the policy definition.
 * @property id The ID of the policy definition.
 * @property metadata The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property mode The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
 * @property name The name of the policy definition.
 * @property parameters The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
 * @property policyRule The policy rule.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource (Microsoft.Authorization/policyDefinitions).
 */
public data class GetPolicyDefinitionResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val metadata: Any? = null,
    public val mode: String? = null,
    public val name: String,
    public val parameters: Map<String, ParameterDefinitionsValueResponse>? = null,
    public val policyRule: Any? = null,
    public val policyType: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetPolicyDefinitionResult): GetPolicyDefinitionResult = GetPolicyDefinitionResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            policyRule = javaType.policyRule().map({ args0 -> args0 }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
