@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The plaResourceID.
 * @property name The pla name.
 * @property properties The private link association properties.
 * @property type The operation type.
 */
public data class GetPrivateLinkAssociationResult(
    public val id: String,
    public val name: String,
    public val properties: PrivateLinkAssociationPropertiesExpandedResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetPrivateLinkAssociationResult): GetPrivateLinkAssociationResult = GetPrivateLinkAssociationResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.PrivateLinkAssociationPropertiesExpandedResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
