@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Role definition.
 * @property assignableScopes Role definition assignable scopes.
 * @property createdBy Id of the user who created the assignment
 * @property createdOn Time it was created
 * @property description The role definition description.
 * @property id The role definition ID.
 * @property name The role definition name.
 * @property permissions Role definition permissions.
 * @property roleName The role name.
 * @property roleType The role type.
 * @property type The role definition type.
 * @property updatedBy Id of the user who updated the assignment
 * @property updatedOn Time it was updated
 */
public data class GetRoleDefinitionResult(
    public val assignableScopes: List<String>? = null,
    public val createdBy: String,
    public val createdOn: String,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val permissions: List<PermissionResponse>? = null,
    public val roleName: String? = null,
    public val roleType: String? = null,
    public val type: String,
    public val updatedBy: String,
    public val updatedOn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetRoleDefinitionResult): GetRoleDefinitionResult = GetRoleDefinitionResult(
            assignableScopes = javaType.assignableScopes().map({ args0 -> args0 }),
            createdBy = javaType.createdBy(),
            createdOn = javaType.createdOn(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            permissions = javaType.permissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.PermissionResponse.Companion.toKotlin(args0)
                })
            }),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            roleType = javaType.roleType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updatedBy = javaType.updatedBy(),
            updatedOn = javaType.updatedOn(),
        )
    }
}
