@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The variable value.
 * @property id The ID of the variable.
 * @property name The name of the variable.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource (Microsoft.Authorization/variables/values).
 * @property values Variable value column value array.
 */
public data class GetVariableValueResult(
    public val id: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val values: List<PolicyVariableValueColumnValueResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetVariableValueResult): GetVariableValueResult = GetVariableValueResult(
            id = javaType.id(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.PolicyVariableValueColumnValueResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
