@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
 * @property message A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
 * @property policyDefinitionReferenceId The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
 */
public data class NonComplianceMessageResponse(
    public val message: String,
    public val policyDefinitionReferenceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.NonComplianceMessageResponse): NonComplianceMessageResponse = NonComplianceMessageResponse(
            message = javaType.message(),
            policyDefinitionReferenceId = javaType.policyDefinitionReferenceId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
