@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Role definition permissions.
 * @property actions Allowed actions.
 * @property condition The conditions on the role definition. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft&#46;Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
 * @property conditionVersion Version of the condition. Currently the only accepted value is '2.0'
 * @property dataActions Allowed Data actions.
 * @property notActions Denied actions.
 * @property notDataActions Denied Data actions.
 */
public data class PermissionResponse(
    public val actions: List<String>? = null,
    public val condition: String,
    public val conditionVersion: String,
    public val dataActions: List<String>? = null,
    public val notActions: List<String>? = null,
    public val notDataActions: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PermissionResponse): PermissionResponse = PermissionResponse(
            actions = javaType.actions().map({ args0 -> args0 }),
            condition = javaType.condition(),
            conditionVersion = javaType.conditionVersion(),
            dataActions = javaType.dataActions().map({ args0 -> args0 }),
            notActions = javaType.notActions().map({ args0 -> args0 }),
            notDataActions = javaType.notDataActions().map({ args0 -> args0 }),
        )
    }
}
