@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the policy
 * @property id Id of the policy
 * @property lastModifiedBy The name of the entity last modified it
 * @property lastModifiedDateTime The last modified date time.
 */
public data class PolicyAssignmentPropertiesResponsePolicy(
    public val id: String? = null,
    public val lastModifiedBy: PrincipalResponse,
    public val lastModifiedDateTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PolicyAssignmentPropertiesResponsePolicy): PolicyAssignmentPropertiesResponsePolicy = PolicyAssignmentPropertiesResponsePolicy(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.PrincipalResponse.Companion.toKotlin(args0)
            }),
            lastModifiedDateTime = javaType.lastModifiedDateTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
