@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The policy definition reference.
 * @property groupNames The name of the groups that this policy definition reference belongs to.
 * @property parameters The parameter values for the referenced policy rule. The keys are the parameter names.
 * @property policyDefinitionId The ID of the policy definition or policy set definition.
 * @property policyDefinitionReferenceId A unique id (within the policy set definition) for this policy definition reference.
 */
public data class PolicyDefinitionReferenceResponse(
    public val groupNames: List<String>? = null,
    public val parameters: Map<String, ParameterValuesValueResponse>? = null,
    public val policyDefinitionId: String,
    public val policyDefinitionReferenceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PolicyDefinitionReferenceResponse): PolicyDefinitionReferenceResponse = PolicyDefinitionReferenceResponse(
            groupNames = javaType.groupNames().map({ args0 -> args0 }),
            parameters = javaType.parameters().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.authorization.kotlin.outputs.ParameterValuesValueResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            policyDefinitionId = javaType.policyDefinitionId(),
            policyDefinitionReferenceId = javaType.policyDefinitionReferenceId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
