@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The name value tuple for this variable value column.
 * @property columnName Column name for the variable value
 * @property columnValue Column value for the variable value; this can be an integer, double, boolean, null or a string.
 */
public data class PolicyVariableValueColumnValueResponse(
    public val columnName: String,
    public val columnValue: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PolicyVariableValueColumnValueResponse): PolicyVariableValueColumnValueResponse = PolicyVariableValueColumnValueResponse(
            columnName = javaType.columnName(),
            columnValue = javaType.columnValue(),
        )
    }
}
