@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The name of the entity last modified it
 * @property displayName The name of the principal made changes
 * @property email Email of principal
 * @property id The id of the principal made changes
 * @property type Type of principal such as user , group etc
 */
public data class PrincipalResponse(
    public val displayName: String? = null,
    public val email: String? = null,
    public val id: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PrincipalResponse): PrincipalResponse = PrincipalResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
