@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private Link Association Properties.
 * @property privateLink The rmpl Resource ID.
 * @property publicNetworkAccess
 * @property scope The scope of the private link association.
 * @property tenantID The TenantID.
 */
public data class PrivateLinkAssociationPropertiesExpandedResponse(
    public val privateLink: String? = null,
    public val publicNetworkAccess: String? = null,
    public val scope: String? = null,
    public val tenantID: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PrivateLinkAssociationPropertiesExpandedResponse): PrivateLinkAssociationPropertiesExpandedResponse =
            PrivateLinkAssociationPropertiesExpandedResponse(
                privateLink = javaType.privateLink().map({ args0 -> args0 }).orElse(null),
                publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
                scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
                tenantID = javaType.tenantID().map({ args0 -> args0 }).orElse(null),
            )
    }
}
