@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The role management policy enablement rule.
 * @property enabledRules The list of enabled rules.
 * @property id The id of the rule.
 * @property ruleType The type of rule
 * Expected value is 'RoleManagementPolicyEnablementRule'.
 * @property target The target of the current rule.
 */
public data class RoleManagementPolicyEnablementRuleResponse(
    public val enabledRules: List<String>? = null,
    public val id: String? = null,
    public val ruleType: String,
    public val target: RoleManagementPolicyRuleTargetResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.RoleManagementPolicyEnablementRuleResponse): RoleManagementPolicyEnablementRuleResponse = RoleManagementPolicyEnablementRuleResponse(
            enabledRules = javaType.enabledRules().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.RoleManagementPolicyRuleTargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
