@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The role management policy rule target.
 * @property caller The caller of the setting.
 * @property enforcedSettings The list of enforced settings.
 * @property inheritableSettings The list of inheritable settings.
 * @property level The assignment level to which rule is applied.
 * @property operations The type of operation.
 * @property targetObjects The list of target objects.
 */
public data class RoleManagementPolicyRuleTargetResponse(
    public val caller: String? = null,
    public val enforcedSettings: List<String>? = null,
    public val inheritableSettings: List<String>? = null,
    public val level: String? = null,
    public val operations: List<String>? = null,
    public val targetObjects: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.RoleManagementPolicyRuleTargetResponse): RoleManagementPolicyRuleTargetResponse = RoleManagementPolicyRuleTargetResponse(
            caller = javaType.caller().map({ args0 -> args0 }).orElse(null),
            enforcedSettings = javaType.enforcedSettings().map({ args0 -> args0 }),
            inheritableSettings = javaType.inheritableSettings().map({ args0 -> args0 }),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            operations = javaType.operations().map({ args0 -> args0 }),
            targetObjects = javaType.targetObjects().map({ args0 -> args0 }),
        )
    }
}
