@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The selector expression.
 * @property in The list of values to filter in.
 * @property kind The selector kind.
 * @property notIn The list of values to filter out.
 */
public data class SelectorResponse(
    public val `in`: List<String>? = null,
    public val kind: String? = null,
    public val notIn: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.SelectorResponse): SelectorResponse = SelectorResponse(
            `in` = javaType.`in`().map({ args0 -> args0 }),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            notIn = javaType.notIn().map({ args0 -> args0 }),
        )
    }
}
