@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.ConfigurationProfileAssignmentArgs.builder
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfileAssignmentPropertiesArgs
import com.pulumi.azurenative.automanage.kotlin.inputs.ConfigurationProfileAssignmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration profile assignment is an association between a VM and automanage profile configuration.
 * Azure REST API version: 2022-05-04. Prior API version in Azure Native 1.x: 2020-06-30-preview.
 * ## Example Usage
 * ### Create or update configuration profile assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfileAssignment = new AzureNative.Automanage.ConfigurationProfileAssignment("configurationProfileAssignment", new()
 *     {
 *         ConfigurationProfileAssignmentName = "default",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfileAssignmentPropertiesArgs
 *         {
 *             ConfigurationProfile = "/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction",
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         VmName = "myVMName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfileAssignment(ctx, "configurationProfileAssignment", &automanage.ConfigurationProfileAssignmentArgs{
 * 			ConfigurationProfileAssignmentName: pulumi.String("default"),
 * 			Properties: &automanage.ConfigurationProfileAssignmentPropertiesArgs{
 * 				ConfigurationProfile: pulumi.String("/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			VmName:            pulumi.String("myVMName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileAssignment;
 * import com.pulumi.azurenative.automanage.ConfigurationProfileAssignmentArgs;
 * import com.pulumi.azurenative.automanage.inputs.ConfigurationProfileAssignmentPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfileAssignment = new ConfigurationProfileAssignment("configurationProfileAssignment", ConfigurationProfileAssignmentArgs.builder()
 *             .configurationProfileAssignmentName("default")
 *             .properties(ConfigurationProfileAssignmentPropertiesArgs.builder()
 *                 .configurationProfile("/providers/Microsoft.Automanage/bestPractices/AzureBestPracticesProduction")
 *                 .build())
 *             .resourceGroupName("myResourceGroupName")
 *             .vmName("myVMName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfileAssignment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}
 * ```
 * @property configurationProfileAssignmentName Name of the configuration profile assignment. Only default is supported.
 * @property properties Properties of the configuration profile assignment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vmName The name of the virtual machine.
 */
public data class ConfigurationProfileAssignmentArgs(
    public val configurationProfileAssignmentName: Output<String>? = null,
    public val properties: Output<ConfigurationProfileAssignmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vmName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.ConfigurationProfileAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.ConfigurationProfileAssignmentArgs =
        com.pulumi.azurenative.automanage.ConfigurationProfileAssignmentArgs.builder()
            .configurationProfileAssignmentName(
                configurationProfileAssignmentName?.applyValue({ args0 ->
                    args0
                }),
            )
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vmName(vmName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfileAssignmentArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileAssignmentArgsBuilder internal constructor() {
    private var configurationProfileAssignmentName: Output<String>? = null

    private var properties: Output<ConfigurationProfileAssignmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var vmName: Output<String>? = null

    /**
     * @param value Name of the configuration profile assignment. Only default is supported.
     */
    @JvmName("cqawetwhkyctwmyu")
    public suspend fun configurationProfileAssignmentName(`value`: Output<String>) {
        this.configurationProfileAssignmentName = value
    }

    /**
     * @param value Properties of the configuration profile assignment.
     */
    @JvmName("kvhcsfnqwhppgxvx")
    public suspend fun properties(`value`: Output<ConfigurationProfileAssignmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kqacugqpskglrgeq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("kfoxunfcwdrrbeyl")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value Name of the configuration profile assignment. Only default is supported.
     */
    @JvmName("kfbloqpjckvvsoqa")
    public suspend fun configurationProfileAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfileAssignmentName = mapped
    }

    /**
     * @param value Properties of the configuration profile assignment.
     */
    @JvmName("frcggfapacwjdfeb")
    public suspend fun properties(`value`: ConfigurationProfileAssignmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the configuration profile assignment.
     */
    @JvmName("opxrqflhyfxghpdg")
    public suspend fun properties(argument: suspend ConfigurationProfileAssignmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfileAssignmentPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rlfvvcuahvjsptmq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("popethncuvnjkpov")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    internal fun build(): ConfigurationProfileAssignmentArgs = ConfigurationProfileAssignmentArgs(
        configurationProfileAssignmentName = configurationProfileAssignmentName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        vmName = vmName,
    )
}
