@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin

import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePreferencePropertiesResponse
import com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePreferencePropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ConfigurationProfilePreference].
 */
@PulumiTagMarker
public class ConfigurationProfilePreferenceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationProfilePreferenceArgs = ConfigurationProfilePreferenceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationProfilePreferenceArgsBuilder.() -> Unit) {
        val builder = ConfigurationProfilePreferenceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationProfilePreference {
        val builtJavaResource =
            com.pulumi.azurenative.automanage.ConfigurationProfilePreference(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationProfilePreference(builtJavaResource)
    }
}

/**
 * Definition of the configuration profile preference.
 * Azure REST API version: 2020-06-30-preview. Prior API version in Azure Native 1.x: 2020-06-30-preview.
 * ## Example Usage
 * ### Create or update configuration profile preference
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationProfilePreference = new AzureNative.Automanage.ConfigurationProfilePreference("configurationProfilePreference", new()
 *     {
 *         ConfigurationProfilePreferenceName = "defaultProfilePreference",
 *         Location = "East US",
 *         Properties = new AzureNative.Automanage.Inputs.ConfigurationProfilePreferencePropertiesArgs
 *         {
 *             AntiMalware = new AzureNative.Automanage.Inputs.ConfigurationProfilePreferenceAntiMalwareArgs
 *             {
 *                 EnableRealTimeProtection = AzureNative.Automanage.EnableRealTimeProtection.True,
 *             },
 *             VmBackup = new AzureNative.Automanage.Inputs.ConfigurationProfilePreferenceVmBackupArgs
 *             {
 *                 TimeZone = "Pacific Standard Time",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         Tags =
 *         {
 *             { "Organization", "Administration" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automanage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automanage.NewConfigurationProfilePreference(ctx, "configurationProfilePreference", &automanage.ConfigurationProfilePreferenceArgs{
 * 			ConfigurationProfilePreferenceName: pulumi.String("defaultProfilePreference"),
 * 			Location:                           pulumi.String("East US"),
 * 			Properties: &automanage.ConfigurationProfilePreferencePropertiesArgs{
 * 				AntiMalware: &automanage.ConfigurationProfilePreferenceAntiMalwareArgs{
 * 					EnableRealTimeProtection: pulumi.String(automanage.EnableRealTimeProtectionTrue),
 * 				},
 * 				VmBackup: &automanage.ConfigurationProfilePreferenceVmBackupArgs{
 * 					TimeZone: pulumi.String("Pacific Standard Time"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"Organization": pulumi.String("Administration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilePreference;
 * import com.pulumi.azurenative.automanage.ConfigurationProfilePreferenceArgs;
 * import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferencePropertiesArgs;
 * import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceAntiMalwareArgs;
 * import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferenceVmBackupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationProfilePreference = new ConfigurationProfilePreference("configurationProfilePreference", ConfigurationProfilePreferenceArgs.builder()
 *             .configurationProfilePreferenceName("defaultProfilePreference")
 *             .location("East US")
 *             .properties(ConfigurationProfilePreferencePropertiesArgs.builder()
 *                 .antiMalware(ConfigurationProfilePreferenceAntiMalwareArgs.builder()
 *                     .enableRealTimeProtection("True")
 *                     .build())
 *                 .vmBackup(ConfigurationProfilePreferenceVmBackupArgs.builder()
 *                     .timeZone("Pacific Standard Time")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroupName")
 *             .tags(Map.of("Organization", "Administration"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automanage:ConfigurationProfilePreference defaultProfilePreference /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfilePreferences/{configurationProfilePreferenceName}
 * ```
 */
public class ConfigurationProfilePreference internal constructor(
    override val javaResource: com.pulumi.azurenative.automanage.ConfigurationProfilePreference,
) : KotlinCustomResource(javaResource, ConfigurationProfilePreferenceMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the configuration profile preference.
     */
    public val properties: Output<ConfigurationProfilePreferencePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationProfilePreferenceMapper : ResourceMapper<ConfigurationProfilePreference> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automanage.ConfigurationProfilePreference::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationProfilePreference =
        ConfigurationProfilePreference(
            javaResource as
                com.pulumi.azurenative.automanage.ConfigurationProfilePreference,
        )
}

/**
 * @see [ConfigurationProfilePreference].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationProfilePreference].
 */
public suspend fun configurationProfilePreference(
    name: String,
    block: suspend ConfigurationProfilePreferenceResourceBuilder.() -> Unit,
): ConfigurationProfilePreference {
    val builder = ConfigurationProfilePreferenceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationProfilePreference].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationProfilePreference(name: String): ConfigurationProfilePreference {
    val builder = ConfigurationProfilePreferenceResourceBuilder()
    builder.name(name)
    return builder.build()
}
