@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.AccountIdentityArgs.builder
import com.pulumi.azurenative.automanage.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the Automanage account.
 * @property type The type of identity used for the Automanage account. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
 */
public data class AccountIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.AccountIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.inputs.AccountIdentityArgs =
        com.pulumi.azurenative.automanage.inputs.AccountIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AccountIdentityArgs].
 */
@PulumiTagMarker
public class AccountIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The type of identity used for the Automanage account. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
     */
    @JvmName("yxsrricslorjqmub")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The type of identity used for the Automanage account. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity.
     */
    @JvmName("mlopkageodwqllkl")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AccountIdentityArgs = AccountIdentityArgs(
        type = type,
    )
}
