@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.ConfigurationProfileAssignmentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Automanage configuration profile assignment properties.
 * @property configurationProfile The Automanage configurationProfile ARM Resource URI.
 */
public data class ConfigurationProfileAssignmentPropertiesArgs(
    public val configurationProfile: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.ConfigurationProfileAssignmentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.inputs.ConfigurationProfileAssignmentPropertiesArgs =
        com.pulumi.azurenative.automanage.inputs.ConfigurationProfileAssignmentPropertiesArgs.builder()
            .configurationProfile(configurationProfile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationProfileAssignmentPropertiesArgs].
 */
@PulumiTagMarker
public class ConfigurationProfileAssignmentPropertiesArgsBuilder internal constructor() {
    private var configurationProfile: Output<String>? = null

    /**
     * @param value The Automanage configurationProfile ARM Resource URI.
     */
    @JvmName("fjdywkmayhinivsg")
    public suspend fun configurationProfile(`value`: Output<String>) {
        this.configurationProfile = value
    }

    /**
     * @param value The Automanage configurationProfile ARM Resource URI.
     */
    @JvmName("hikdnluchhnscfcv")
    public suspend fun configurationProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationProfile = mapped
    }

    internal fun build(): ConfigurationProfileAssignmentPropertiesArgs =
        ConfigurationProfileAssignmentPropertiesArgs(
            configurationProfile = configurationProfile,
        )
}
