@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferencePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Automanage configuration profile preference properties.
 * @property antiMalware The custom preferences for Azure Antimalware.
 * @property vmBackup The custom preferences for Azure VM Backup.
 */
public data class ConfigurationProfilePreferencePropertiesArgs(
    public val antiMalware: Output<ConfigurationProfilePreferenceAntiMalwareArgs>? = null,
    public val vmBackup: Output<ConfigurationProfilePreferenceVmBackupArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferencePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferencePropertiesArgs =
        com.pulumi.azurenative.automanage.inputs.ConfigurationProfilePreferencePropertiesArgs.builder()
            .antiMalware(antiMalware?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmBackup(vmBackup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigurationProfilePreferencePropertiesArgs].
 */
@PulumiTagMarker
public class ConfigurationProfilePreferencePropertiesArgsBuilder internal constructor() {
    private var antiMalware: Output<ConfigurationProfilePreferenceAntiMalwareArgs>? = null

    private var vmBackup: Output<ConfigurationProfilePreferenceVmBackupArgs>? = null

    /**
     * @param value The custom preferences for Azure Antimalware.
     */
    @JvmName("wkncxglrhpfpkitg")
    public suspend fun antiMalware(`value`: Output<ConfigurationProfilePreferenceAntiMalwareArgs>) {
        this.antiMalware = value
    }

    /**
     * @param value The custom preferences for Azure VM Backup.
     */
    @JvmName("bsvsuxxpjhclkwfq")
    public suspend fun vmBackup(`value`: Output<ConfigurationProfilePreferenceVmBackupArgs>) {
        this.vmBackup = value
    }

    /**
     * @param value The custom preferences for Azure Antimalware.
     */
    @JvmName("guktbkubfkehuixq")
    public suspend fun antiMalware(`value`: ConfigurationProfilePreferenceAntiMalwareArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.antiMalware = mapped
    }

    /**
     * @param argument The custom preferences for Azure Antimalware.
     */
    @JvmName("mrmdovlfiunxcsfx")
    public suspend fun antiMalware(argument: suspend ConfigurationProfilePreferenceAntiMalwareArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfilePreferenceAntiMalwareArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.antiMalware = mapped
    }

    /**
     * @param value The custom preferences for Azure VM Backup.
     */
    @JvmName("ydyfrkavtymwlvns")
    public suspend fun vmBackup(`value`: ConfigurationProfilePreferenceVmBackupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmBackup = mapped
    }

    /**
     * @param argument The custom preferences for Azure VM Backup.
     */
    @JvmName("efpuwlswrlwwgdje")
    public suspend fun vmBackup(argument: suspend ConfigurationProfilePreferenceVmBackupArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationProfilePreferenceVmBackupArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vmBackup = mapped
    }

    internal fun build(): ConfigurationProfilePreferencePropertiesArgs =
        ConfigurationProfilePreferencePropertiesArgs(
            antiMalware = antiMalware,
            vmBackup = vmBackup,
        )
}
