@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.inputs

import com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCIAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Arc machine.
 * @property configurationProfileAssignmentName The configuration profile assignment name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetConfigurationProfileHCIAssignmentPlainArgs(
    public val clusterName: String,
    public val configurationProfileAssignmentName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCIAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCIAssignmentPlainArgs =
        com.pulumi.azurenative.automanage.inputs.GetConfigurationProfileHCIAssignmentPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .configurationProfileAssignmentName(configurationProfileAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationProfileHCIAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationProfileHCIAssignmentPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var configurationProfileAssignmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Arc machine.
     */
    @JvmName("jewseigoudammnle")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The configuration profile assignment name.
     */
    @JvmName("esbglqheukvqgbhu")
    public suspend fun configurationProfileAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationProfileAssignmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("heylvyvdihvewoab")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationProfileHCIAssignmentPlainArgs =
        GetConfigurationProfileHCIAssignmentPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            configurationProfileAssignmentName = configurationProfileAssignmentName ?: throw
                PulumiNullFieldException("configurationProfileAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
