@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Automanage configuration profile Antimalware preferences.
 * @property enableRealTimeProtection Enables or disables Real Time Protection
 * @property exclusions Extensions, Paths and Processes that must be excluded from scan
 * @property runScheduledScan Enables or disables a periodic scan for antimalware
 * @property scanDay Schedule scan settings day
 * @property scanTimeInMinutes Schedule scan settings time
 * @property scanType Type of scheduled scan
 */
public data class ConfigurationProfilePreferenceAntiMalwareResponse(
    public val enableRealTimeProtection: String? = null,
    public val exclusions: Any? = null,
    public val runScheduledScan: String? = null,
    public val scanDay: String? = null,
    public val scanTimeInMinutes: String? = null,
    public val scanType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automanage.outputs.ConfigurationProfilePreferenceAntiMalwareResponse): ConfigurationProfilePreferenceAntiMalwareResponse =
            ConfigurationProfilePreferenceAntiMalwareResponse(
                enableRealTimeProtection = javaType.enableRealTimeProtection().map({ args0 -> args0 }).orElse(null),
                exclusions = javaType.exclusions().map({ args0 -> args0 }).orElse(null),
                runScheduledScan = javaType.runScheduledScan().map({ args0 -> args0 }).orElse(null),
                scanDay = javaType.scanDay().map({ args0 -> args0 }).orElse(null),
                scanTimeInMinutes = javaType.scanTimeInMinutes().map({ args0 -> args0 }).orElse(null),
                scanType = javaType.scanType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
