@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.outputs

import kotlin.Suppress

/**
 * Automanage configuration profile preference properties.
 * @property antiMalware The custom preferences for Azure Antimalware.
 * @property vmBackup The custom preferences for Azure VM Backup.
 */
public data class ConfigurationProfilePreferencePropertiesResponse(
    public val antiMalware: ConfigurationProfilePreferenceAntiMalwareResponse? = null,
    public val vmBackup: ConfigurationProfilePreferenceVmBackupResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automanage.outputs.ConfigurationProfilePreferencePropertiesResponse): ConfigurationProfilePreferencePropertiesResponse =
            ConfigurationProfilePreferencePropertiesResponse(
                antiMalware = javaType.antiMalware().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePreferenceAntiMalwareResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                vmBackup = javaType.vmBackup().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfilePreferenceVmBackupResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
