@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automanage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration profile assignment is an association between a VM and automanage profile configuration.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property managedBy Azure resource id. Indicates if this resource is managed by another Azure resource.
 * @property name The name of the resource
 * @property properties Properties of the configuration profile assignment.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetConfigurationProfileHCIAssignmentResult(
    public val id: String,
    public val managedBy: String,
    public val name: String,
    public val properties: ConfigurationProfileAssignmentPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.automanage.outputs.GetConfigurationProfileHCIAssignmentResult): GetConfigurationProfileHCIAssignmentResult = GetConfigurationProfileHCIAssignmentResult(
            id = javaType.id(),
            managedBy = javaType.managedBy(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.automanage.kotlin.outputs.ConfigurationProfileAssignmentPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.automanage.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
