@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.AutomationAccountArgs.builder
import com.pulumi.azurenative.automation.kotlin.inputs.EncryptionPropertiesArgs
import com.pulumi.azurenative.automation.kotlin.inputs.EncryptionPropertiesArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.automation.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.automation.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the automation account type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2021-06-22.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update automation account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var automationAccount = new AzureNative.Automation.AutomationAccount("automationAccount", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount9",
 *         Location = "East US 2",
 *         Name = "myAutomationAccount9",
 *         ResourceGroupName = "rg",
 *         Sku = new AzureNative.Automation.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Automation.SkuNameEnum.Free,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewAutomationAccount(ctx, "automationAccount", &automation.AutomationAccountArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount9"),
 * 			Location:              pulumi.String("East US 2"),
 * 			Name:                  pulumi.String("myAutomationAccount9"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			Sku: &automation.SkuArgs{
 * 				Name: pulumi.String(automation.SkuNameEnumFree),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.AutomationAccount;
 * import com.pulumi.azurenative.automation.AutomationAccountArgs;
 * import com.pulumi.azurenative.automation.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var automationAccount = new AutomationAccount("automationAccount", AutomationAccountArgs.builder()
 *             .automationAccountName("myAutomationAccount9")
 *             .location("East US 2")
 *             .name("myAutomationAccount9")
 *             .resourceGroupName("rg")
 *             .sku(SkuArgs.builder()
 *                 .name("Free")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:AutomationAccount ContoseAutomationAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property disableLocalAuth Indicates whether requests using non-AAD authentication are blocked
 * @property encryption Set the encryption properties for the automation account
 * @property identity Sets the identity property for automation account
 * @property location Gets or sets the location of the resource.
 * @property name Gets or sets name of the resource.
 * @property publicNetworkAccess Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
 * @property resourceGroupName Name of an Azure Resource group.
 * @property sku Gets or sets account SKU.
 * @property tags Gets or sets the tags attached to the resource.
 */
public data class AutomationAccountArgs(
    public val automationAccountName: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val encryption: Output<EncryptionPropertiesArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val publicNetworkAccess: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.AutomationAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.AutomationAccountArgs =
        com.pulumi.azurenative.automation.AutomationAccountArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AutomationAccountArgs].
 */
@PulumiTagMarker
public class AutomationAccountArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var encryption: Output<EncryptionPropertiesArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var publicNetworkAccess: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("rbwsioqxcsriixhb")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value Indicates whether requests using non-AAD authentication are blocked
     */
    @JvmName("dogeegxfkeaqissr")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Set the encryption properties for the automation account
     */
    @JvmName("tcafikpjabbxmpei")
    public suspend fun encryption(`value`: Output<EncryptionPropertiesArgs>) {
        this.encryption = value
    }

    /**
     * @param value Sets the identity property for automation account
     */
    @JvmName("obuitsxkiywxciha")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("rpggckqdbvgntovl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets name of the resource.
     */
    @JvmName("jwxigckewxkxxrkm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
     */
    @JvmName("odnqxtglbtjxrumc")
    public suspend fun publicNetworkAccess(`value`: Output<Boolean>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("ljsqrenudbsphxoc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets account SKU.
     */
    @JvmName("xmlyikyaaytrsoyp")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("chjdpiqyihactqya")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("jyatynlwomopmbgn")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value Indicates whether requests using non-AAD authentication are blocked
     */
    @JvmName("knundgoexxxdrgbn")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Set the encryption properties for the automation account
     */
    @JvmName("emjbvcfrgkrbyfub")
    public suspend fun encryption(`value`: EncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Set the encryption properties for the automation account
     */
    @JvmName("vvbddldhilvhccsu")
    public suspend fun encryption(argument: suspend EncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Sets the identity property for automation account
     */
    @JvmName("hknvbepykljabcqf")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Sets the identity property for automation account
     */
    @JvmName("uclelqdhislcomjl")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Gets or sets the location of the resource.
     */
    @JvmName("lsuyepssqlradtxq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets name of the resource.
     */
    @JvmName("xhydrkmrbqxnjqch")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether traffic on the non-ARM endpoint (Webhook/Agent) is allowed from the public internet
     */
    @JvmName("fpfcndjoqjewqnvu")
    public suspend fun publicNetworkAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("qwnbnkkrpnankjng")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets account SKU.
     */
    @JvmName("dhkddccecmtqflat")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Gets or sets account SKU.
     */
    @JvmName("etmvjnaegcjgnqwk")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Gets or sets the tags attached to the resource.
     */
    @JvmName("fooqtkefhejhiwub")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags attached to the resource.
     */
    @JvmName("ugqubarjkijpbiqr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AutomationAccountArgs = AutomationAccountArgs(
        automationAccountName = automationAccountName,
        disableLocalAuth = disableLocalAuth,
        encryption = encryption,
        identity = identity,
        location = location,
        name = name,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
