@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.AutomationFunctions.getAutomationAccountPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getCertificatePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getConnectionPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getConnectionTypePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getCredentialPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getDscConfigurationPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getDscNodeConfigurationPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getHybridRunbookWorkerGroupPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getHybridRunbookWorkerPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getJobSchedulePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getModulePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getPackagePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getPowerShell72ModulePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getPython2PackagePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getPython3PackagePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getRunbookPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getRuntimeEnvironmentPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getSchedulePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getSoftwareUpdateConfigurationByNamePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getSourceControlPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getVariablePlain
import com.pulumi.azurenative.automation.AutomationFunctions.getWatcherPlain
import com.pulumi.azurenative.automation.AutomationFunctions.getWebhookPlain
import com.pulumi.azurenative.automation.AutomationFunctions.listAutomationAccountDeletedRunbooksPlain
import com.pulumi.azurenative.automation.AutomationFunctions.listKeyByAutomationAccountPlain
import com.pulumi.azurenative.automation.kotlin.inputs.GetAutomationAccountPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetAutomationAccountPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetConnectionTypePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetConnectionTypePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetCredentialPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetCredentialPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetDscConfigurationPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetDscConfigurationPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetDscNodeConfigurationPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetDscNodeConfigurationPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetHybridRunbookWorkerGroupPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetHybridRunbookWorkerGroupPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetHybridRunbookWorkerPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetHybridRunbookWorkerPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetJobSchedulePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetJobSchedulePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetModulePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetModulePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetPackagePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetPackagePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetPowerShell72ModulePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetPowerShell72ModulePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetPython2PackagePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetPython2PackagePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetPython3PackagePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetPython3PackagePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetRunbookPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetRunbookPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetRuntimeEnvironmentPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetRuntimeEnvironmentPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetSchedulePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetSchedulePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetSoftwareUpdateConfigurationByNamePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetSoftwareUpdateConfigurationByNamePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetSourceControlPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetSourceControlPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetVariablePlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetVariablePlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetWatcherPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetWatcherPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.GetWebhookPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.GetWebhookPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.ListAutomationAccountDeletedRunbooksPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ListAutomationAccountDeletedRunbooksPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.inputs.ListKeyByAutomationAccountPlainArgs
import com.pulumi.azurenative.automation.kotlin.inputs.ListKeyByAutomationAccountPlainArgsBuilder
import com.pulumi.azurenative.automation.kotlin.outputs.GetAutomationAccountResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetCertificateResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetConnectionResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetConnectionTypeResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetCredentialResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetDscConfigurationResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetDscNodeConfigurationResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetHybridRunbookWorkerGroupResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetHybridRunbookWorkerResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetJobScheduleResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetModuleResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetPackageResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetPowerShell72ModuleResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetPython2PackageResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetPython3PackageResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetRunbookResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetRuntimeEnvironmentResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetScheduleResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetSoftwareUpdateConfigurationByNameResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetSourceControlResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetVariableResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetWatcherResult
import com.pulumi.azurenative.automation.kotlin.outputs.GetWebhookResult
import com.pulumi.azurenative.automation.kotlin.outputs.ListAutomationAccountDeletedRunbooksResult
import com.pulumi.azurenative.automation.kotlin.outputs.ListKeyByAutomationAccountResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.automation.kotlin.outputs.GetAutomationAccountResult.Companion.toKotlin as getAutomationAccountResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetConnectionResult.Companion.toKotlin as getConnectionResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetConnectionTypeResult.Companion.toKotlin as getConnectionTypeResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetCredentialResult.Companion.toKotlin as getCredentialResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetDscConfigurationResult.Companion.toKotlin as getDscConfigurationResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetDscNodeConfigurationResult.Companion.toKotlin as getDscNodeConfigurationResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetHybridRunbookWorkerGroupResult.Companion.toKotlin as getHybridRunbookWorkerGroupResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetHybridRunbookWorkerResult.Companion.toKotlin as getHybridRunbookWorkerResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetJobScheduleResult.Companion.toKotlin as getJobScheduleResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetModuleResult.Companion.toKotlin as getModuleResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetPackageResult.Companion.toKotlin as getPackageResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetPowerShell72ModuleResult.Companion.toKotlin as getPowerShell72ModuleResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetPython2PackageResult.Companion.toKotlin as getPython2PackageResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetPython3PackageResult.Companion.toKotlin as getPython3PackageResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetRunbookResult.Companion.toKotlin as getRunbookResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetRuntimeEnvironmentResult.Companion.toKotlin as getRuntimeEnvironmentResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetScheduleResult.Companion.toKotlin as getScheduleResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetSoftwareUpdateConfigurationByNameResult.Companion.toKotlin as getSoftwareUpdateConfigurationByNameResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetSourceControlResult.Companion.toKotlin as getSourceControlResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetVariableResult.Companion.toKotlin as getVariableResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetWatcherResult.Companion.toKotlin as getWatcherResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.GetWebhookResult.Companion.toKotlin as getWebhookResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.ListAutomationAccountDeletedRunbooksResult.Companion.toKotlin as listAutomationAccountDeletedRunbooksResultToKotlin
import com.pulumi.azurenative.automation.kotlin.outputs.ListKeyByAutomationAccountResult.Companion.toKotlin as listKeyByAutomationAccountResultToKotlin

public object AutomationFunctions {
    /**
     * Get information about an Automation Account.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the automation account type.
     */
    public suspend fun getAutomationAccount(argument: GetAutomationAccountPlainArgs): GetAutomationAccountResult =
        getAutomationAccountResultToKotlin(getAutomationAccountPlain(argument.toJava()).await())

    /**
     * @see [getAutomationAccount].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the automation account type.
     */
    public suspend fun getAutomationAccount(automationAccountName: String, resourceGroupName: String): GetAutomationAccountResult {
        val argument = GetAutomationAccountPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return getAutomationAccountResultToKotlin(getAutomationAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAutomationAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetAutomationAccountPlainArgs].
     * @return Definition of the automation account type.
     */
    public suspend fun getAutomationAccount(argument: suspend GetAutomationAccountPlainArgsBuilder.() -> Unit): GetAutomationAccountResult {
        val builder = GetAutomationAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAutomationAccountResultToKotlin(getAutomationAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the certificate identified by certificate name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the certificate.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param automationAccountName The name of the automation account.
     * @param certificateName The name of certificate.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the certificate.
     */
    public suspend fun getCertificate(
        automationAccountName: String,
        certificateName: String,
        resourceGroupName: String,
    ): GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            automationAccountName = automationAccountName,
            certificateName = certificateName,
            resourceGroupName = resourceGroupName,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return Definition of the certificate.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit): GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the connection identified by connection name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the connection.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param automationAccountName The name of the automation account.
     * @param connectionName The name of connection.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the connection.
     */
    public suspend fun getConnection(
        automationAccountName: String,
        connectionName: String,
        resourceGroupName: String,
    ): GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            automationAccountName = automationAccountName,
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return Definition of the connection.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit): GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionResultToKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the connection type identified by connection type name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the connection type.
     */
    public suspend fun getConnectionType(argument: GetConnectionTypePlainArgs): GetConnectionTypeResult =
        getConnectionTypeResultToKotlin(getConnectionTypePlain(argument.toJava()).await())

    /**
     * @see [getConnectionType].
     * @param automationAccountName The name of the automation account.
     * @param connectionTypeName The name of connection type.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the connection type.
     */
    public suspend fun getConnectionType(
        automationAccountName: String,
        connectionTypeName: String,
        resourceGroupName: String,
    ): GetConnectionTypeResult {
        val argument = GetConnectionTypePlainArgs(
            automationAccountName = automationAccountName,
            connectionTypeName = connectionTypeName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectionTypeResultToKotlin(getConnectionTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectionType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetConnectionTypePlainArgs].
     * @return Definition of the connection type.
     */
    public suspend fun getConnectionType(argument: suspend GetConnectionTypePlainArgsBuilder.() -> Unit): GetConnectionTypeResult {
        val builder = GetConnectionTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionTypeResultToKotlin(getConnectionTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the credential identified by credential name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the credential.
     */
    public suspend fun getCredential(argument: GetCredentialPlainArgs): GetCredentialResult =
        getCredentialResultToKotlin(getCredentialPlain(argument.toJava()).await())

    /**
     * @see [getCredential].
     * @param automationAccountName The name of the automation account.
     * @param credentialName The name of credential.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the credential.
     */
    public suspend fun getCredential(
        automationAccountName: String,
        credentialName: String,
        resourceGroupName: String,
    ): GetCredentialResult {
        val argument = GetCredentialPlainArgs(
            automationAccountName = automationAccountName,
            credentialName = credentialName,
            resourceGroupName = resourceGroupName,
        )
        return getCredentialResultToKotlin(getCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [getCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetCredentialPlainArgs].
     * @return Definition of the credential.
     */
    public suspend fun getCredential(argument: suspend GetCredentialPlainArgsBuilder.() -> Unit): GetCredentialResult {
        val builder = GetCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCredentialResultToKotlin(getCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the configuration identified by configuration name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the configuration type.
     */
    public suspend fun getDscConfiguration(argument: GetDscConfigurationPlainArgs): GetDscConfigurationResult =
        getDscConfigurationResultToKotlin(getDscConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getDscConfiguration].
     * @param automationAccountName The name of the automation account.
     * @param configurationName The configuration name.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the configuration type.
     */
    public suspend fun getDscConfiguration(
        automationAccountName: String,
        configurationName: String,
        resourceGroupName: String,
    ): GetDscConfigurationResult {
        val argument = GetDscConfigurationPlainArgs(
            automationAccountName = automationAccountName,
            configurationName = configurationName,
            resourceGroupName = resourceGroupName,
        )
        return getDscConfigurationResultToKotlin(getDscConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDscConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetDscConfigurationPlainArgs].
     * @return Definition of the configuration type.
     */
    public suspend fun getDscConfiguration(argument: suspend GetDscConfigurationPlainArgsBuilder.() -> Unit): GetDscConfigurationResult {
        val builder = GetDscConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDscConfigurationResultToKotlin(getDscConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the Dsc node configurations by node configuration.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the dsc node configuration.
     */
    public suspend fun getDscNodeConfiguration(argument: GetDscNodeConfigurationPlainArgs): GetDscNodeConfigurationResult =
        getDscNodeConfigurationResultToKotlin(getDscNodeConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getDscNodeConfiguration].
     * @param automationAccountName The name of the automation account.
     * @param nodeConfigurationName The Dsc node configuration name.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the dsc node configuration.
     */
    public suspend fun getDscNodeConfiguration(
        automationAccountName: String,
        nodeConfigurationName: String,
        resourceGroupName: String,
    ): GetDscNodeConfigurationResult {
        val argument = GetDscNodeConfigurationPlainArgs(
            automationAccountName = automationAccountName,
            nodeConfigurationName = nodeConfigurationName,
            resourceGroupName = resourceGroupName,
        )
        return getDscNodeConfigurationResultToKotlin(getDscNodeConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDscNodeConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetDscNodeConfigurationPlainArgs].
     * @return Definition of the dsc node configuration.
     */
    public suspend fun getDscNodeConfiguration(argument: suspend GetDscNodeConfigurationPlainArgsBuilder.() -> Unit): GetDscNodeConfigurationResult {
        val builder = GetDscNodeConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDscNodeConfigurationResultToKotlin(getDscNodeConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve a hybrid runbook worker.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of hybrid runbook worker.
     */
    public suspend fun getHybridRunbookWorker(argument: GetHybridRunbookWorkerPlainArgs): GetHybridRunbookWorkerResult =
        getHybridRunbookWorkerResultToKotlin(getHybridRunbookWorkerPlain(argument.toJava()).await())

    /**
     * @see [getHybridRunbookWorker].
     * @param automationAccountName The name of the automation account.
     * @param hybridRunbookWorkerGroupName The hybrid runbook worker group name
     * @param hybridRunbookWorkerId The hybrid runbook worker id
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of hybrid runbook worker.
     */
    public suspend fun getHybridRunbookWorker(
        automationAccountName: String,
        hybridRunbookWorkerGroupName: String,
        hybridRunbookWorkerId: String,
        resourceGroupName: String,
    ): GetHybridRunbookWorkerResult {
        val argument = GetHybridRunbookWorkerPlainArgs(
            automationAccountName = automationAccountName,
            hybridRunbookWorkerGroupName = hybridRunbookWorkerGroupName,
            hybridRunbookWorkerId = hybridRunbookWorkerId,
            resourceGroupName = resourceGroupName,
        )
        return getHybridRunbookWorkerResultToKotlin(getHybridRunbookWorkerPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridRunbookWorker].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetHybridRunbookWorkerPlainArgs].
     * @return Definition of hybrid runbook worker.
     */
    public suspend fun getHybridRunbookWorker(argument: suspend GetHybridRunbookWorkerPlainArgsBuilder.() -> Unit): GetHybridRunbookWorkerResult {
        val builder = GetHybridRunbookWorkerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridRunbookWorkerResultToKotlin(getHybridRunbookWorkerPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve a hybrid runbook worker group.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2021-06-22, 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of hybrid runbook worker group.
     */
    public suspend fun getHybridRunbookWorkerGroup(argument: GetHybridRunbookWorkerGroupPlainArgs): GetHybridRunbookWorkerGroupResult =
        getHybridRunbookWorkerGroupResultToKotlin(getHybridRunbookWorkerGroupPlain(argument.toJava()).await())

    /**
     * @see [getHybridRunbookWorkerGroup].
     * @param automationAccountName The name of the automation account.
     * @param hybridRunbookWorkerGroupName The hybrid runbook worker group name
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of hybrid runbook worker group.
     */
    public suspend fun getHybridRunbookWorkerGroup(
        automationAccountName: String,
        hybridRunbookWorkerGroupName: String,
        resourceGroupName: String,
    ): GetHybridRunbookWorkerGroupResult {
        val argument = GetHybridRunbookWorkerGroupPlainArgs(
            automationAccountName = automationAccountName,
            hybridRunbookWorkerGroupName = hybridRunbookWorkerGroupName,
            resourceGroupName = resourceGroupName,
        )
        return getHybridRunbookWorkerGroupResultToKotlin(getHybridRunbookWorkerGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridRunbookWorkerGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetHybridRunbookWorkerGroupPlainArgs].
     * @return Definition of hybrid runbook worker group.
     */
    public suspend fun getHybridRunbookWorkerGroup(argument: suspend GetHybridRunbookWorkerGroupPlainArgsBuilder.() -> Unit): GetHybridRunbookWorkerGroupResult {
        val builder = GetHybridRunbookWorkerGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridRunbookWorkerGroupResultToKotlin(getHybridRunbookWorkerGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the job schedule identified by job schedule name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the job schedule.
     */
    public suspend fun getJobSchedule(argument: GetJobSchedulePlainArgs): GetJobScheduleResult =
        getJobScheduleResultToKotlin(getJobSchedulePlain(argument.toJava()).await())

    /**
     * @see [getJobSchedule].
     * @param automationAccountName The name of the automation account.
     * @param jobScheduleId The job schedule name.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the job schedule.
     */
    public suspend fun getJobSchedule(
        automationAccountName: String,
        jobScheduleId: String,
        resourceGroupName: String,
    ): GetJobScheduleResult {
        val argument = GetJobSchedulePlainArgs(
            automationAccountName = automationAccountName,
            jobScheduleId = jobScheduleId,
            resourceGroupName = resourceGroupName,
        )
        return getJobScheduleResultToKotlin(getJobSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getJobSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetJobSchedulePlainArgs].
     * @return Definition of the job schedule.
     */
    public suspend fun getJobSchedule(argument: suspend GetJobSchedulePlainArgsBuilder.() -> Unit): GetJobScheduleResult {
        val builder = GetJobSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobScheduleResultToKotlin(getJobSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the module identified by module name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the module type.
     */
    public suspend fun getModule(argument: GetModulePlainArgs): GetModuleResult =
        getModuleResultToKotlin(getModulePlain(argument.toJava()).await())

    /**
     * @see [getModule].
     * @param automationAccountName The name of the automation account.
     * @param moduleName The module name.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the module type.
     */
    public suspend fun getModule(
        automationAccountName: String,
        moduleName: String,
        resourceGroupName: String,
    ): GetModuleResult {
        val argument = GetModulePlainArgs(
            automationAccountName = automationAccountName,
            moduleName = moduleName,
            resourceGroupName = resourceGroupName,
        )
        return getModuleResultToKotlin(getModulePlain(argument.toJava()).await())
    }

    /**
     * @see [getModule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetModulePlainArgs].
     * @return Definition of the module type.
     */
    public suspend fun getModule(argument: suspend GetModulePlainArgsBuilder.() -> Unit): GetModuleResult {
        val builder = GetModulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModuleResultToKotlin(getModulePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the Package identified by Package name.
     * Azure REST API version: 2023-05-15-preview.
     * @param argument null
     * @return Definition of the Package type.
     */
    public suspend fun getPackage(argument: GetPackagePlainArgs): GetPackageResult =
        getPackageResultToKotlin(getPackagePlain(argument.toJava()).await())

    /**
     * @see [getPackage].
     * @param automationAccountName The name of the automation account.
     * @param packageName The Package name.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param runtimeEnvironmentName The name of the Runtime Environment.
     * @return Definition of the Package type.
     */
    public suspend fun getPackage(
        automationAccountName: String,
        packageName: String,
        resourceGroupName: String,
        runtimeEnvironmentName: String,
    ): GetPackageResult {
        val argument = GetPackagePlainArgs(
            automationAccountName = automationAccountName,
            packageName = packageName,
            resourceGroupName = resourceGroupName,
            runtimeEnvironmentName = runtimeEnvironmentName,
        )
        return getPackageResultToKotlin(getPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetPackagePlainArgs].
     * @return Definition of the Package type.
     */
    public suspend fun getPackage(argument: suspend GetPackagePlainArgsBuilder.() -> Unit): GetPackageResult {
        val builder = GetPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPackageResultToKotlin(getPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the module identified by module name.
     * Azure REST API version: 2023-11-01.
     * @param argument null
     * @return Definition of the module type.
     */
    public suspend fun getPowerShell72Module(argument: GetPowerShell72ModulePlainArgs): GetPowerShell72ModuleResult =
        getPowerShell72ModuleResultToKotlin(getPowerShell72ModulePlain(argument.toJava()).await())

    /**
     * @see [getPowerShell72Module].
     * @param automationAccountName The name of the automation account.
     * @param moduleName The name of module.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Definition of the module type.
     */
    public suspend fun getPowerShell72Module(
        automationAccountName: String,
        moduleName: String,
        resourceGroupName: String,
    ): GetPowerShell72ModuleResult {
        val argument = GetPowerShell72ModulePlainArgs(
            automationAccountName = automationAccountName,
            moduleName = moduleName,
            resourceGroupName = resourceGroupName,
        )
        return getPowerShell72ModuleResultToKotlin(getPowerShell72ModulePlain(argument.toJava()).await())
    }

    /**
     * @see [getPowerShell72Module].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetPowerShell72ModulePlainArgs].
     * @return Definition of the module type.
     */
    public suspend fun getPowerShell72Module(argument: suspend GetPowerShell72ModulePlainArgsBuilder.() -> Unit): GetPowerShell72ModuleResult {
        val builder = GetPowerShell72ModulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPowerShell72ModuleResultToKotlin(getPowerShell72ModulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2020-01-13-preview.
     * Other available API versions: 2023-05-15-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param automationAccountName The name of the automation account.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        automationAccountName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            automationAccountName = automationAccountName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the python 2 package identified by package name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the module type.
     */
    public suspend fun getPython2Package(argument: GetPython2PackagePlainArgs): GetPython2PackageResult =
        getPython2PackageResultToKotlin(getPython2PackagePlain(argument.toJava()).await())

    /**
     * @see [getPython2Package].
     * @param automationAccountName The name of the automation account.
     * @param packageName The python package name.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the module type.
     */
    public suspend fun getPython2Package(
        automationAccountName: String,
        packageName: String,
        resourceGroupName: String,
    ): GetPython2PackageResult {
        val argument = GetPython2PackagePlainArgs(
            automationAccountName = automationAccountName,
            packageName = packageName,
            resourceGroupName = resourceGroupName,
        )
        return getPython2PackageResultToKotlin(getPython2PackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getPython2Package].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetPython2PackagePlainArgs].
     * @return Definition of the module type.
     */
    public suspend fun getPython2Package(argument: suspend GetPython2PackagePlainArgsBuilder.() -> Unit): GetPython2PackageResult {
        val builder = GetPython2PackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPython2PackageResultToKotlin(getPython2PackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the python 3 package identified by package name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the module type.
     */
    public suspend fun getPython3Package(argument: GetPython3PackagePlainArgs): GetPython3PackageResult =
        getPython3PackageResultToKotlin(getPython3PackagePlain(argument.toJava()).await())

    /**
     * @see [getPython3Package].
     * @param automationAccountName The name of the automation account.
     * @param packageName The python package name.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return Definition of the module type.
     */
    public suspend fun getPython3Package(
        automationAccountName: String,
        packageName: String,
        resourceGroupName: String,
    ): GetPython3PackageResult {
        val argument = GetPython3PackagePlainArgs(
            automationAccountName = automationAccountName,
            packageName = packageName,
            resourceGroupName = resourceGroupName,
        )
        return getPython3PackageResultToKotlin(getPython3PackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getPython3Package].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetPython3PackagePlainArgs].
     * @return Definition of the module type.
     */
    public suspend fun getPython3Package(argument: suspend GetPython3PackagePlainArgsBuilder.() -> Unit): GetPython3PackageResult {
        val builder = GetPython3PackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPython3PackageResultToKotlin(getPython3PackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the runbook identified by runbook name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the runbook type.
     */
    public suspend fun getRunbook(argument: GetRunbookPlainArgs): GetRunbookResult =
        getRunbookResultToKotlin(getRunbookPlain(argument.toJava()).await())

    /**
     * @see [getRunbook].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param runbookName The runbook name.
     * @return Definition of the runbook type.
     */
    public suspend fun getRunbook(
        automationAccountName: String,
        resourceGroupName: String,
        runbookName: String,
    ): GetRunbookResult {
        val argument = GetRunbookPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            runbookName = runbookName,
        )
        return getRunbookResultToKotlin(getRunbookPlain(argument.toJava()).await())
    }

    /**
     * @see [getRunbook].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetRunbookPlainArgs].
     * @return Definition of the runbook type.
     */
    public suspend fun getRunbook(argument: suspend GetRunbookPlainArgsBuilder.() -> Unit): GetRunbookResult {
        val builder = GetRunbookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRunbookResultToKotlin(getRunbookPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about the Runtime Environment
     * Azure REST API version: 2023-05-15-preview.
     * @param argument null
     * @return Definition of the Runtime Environment type.
     */
    public suspend fun getRuntimeEnvironment(argument: GetRuntimeEnvironmentPlainArgs): GetRuntimeEnvironmentResult =
        getRuntimeEnvironmentResultToKotlin(getRuntimeEnvironmentPlain(argument.toJava()).await())

    /**
     * @see [getRuntimeEnvironment].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param runtimeEnvironmentName The name of the Runtime Environment.
     * @return Definition of the Runtime Environment type.
     */
    public suspend fun getRuntimeEnvironment(
        automationAccountName: String,
        resourceGroupName: String,
        runtimeEnvironmentName: String,
    ): GetRuntimeEnvironmentResult {
        val argument = GetRuntimeEnvironmentPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            runtimeEnvironmentName = runtimeEnvironmentName,
        )
        return getRuntimeEnvironmentResultToKotlin(getRuntimeEnvironmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getRuntimeEnvironment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetRuntimeEnvironmentPlainArgs].
     * @return Definition of the Runtime Environment type.
     */
    public suspend fun getRuntimeEnvironment(argument: suspend GetRuntimeEnvironmentPlainArgsBuilder.() -> Unit): GetRuntimeEnvironmentResult {
        val builder = GetRuntimeEnvironmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRuntimeEnvironmentResultToKotlin(getRuntimeEnvironmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the schedule identified by schedule name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the schedule.
     */
    public suspend fun getSchedule(argument: GetSchedulePlainArgs): GetScheduleResult =
        getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())

    /**
     * @see [getSchedule].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param scheduleName The schedule name.
     * @return Definition of the schedule.
     */
    public suspend fun getSchedule(
        automationAccountName: String,
        resourceGroupName: String,
        scheduleName: String,
    ): GetScheduleResult {
        val argument = GetSchedulePlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            scheduleName = scheduleName,
        )
        return getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetSchedulePlainArgs].
     * @return Definition of the schedule.
     */
    public suspend fun getSchedule(argument: suspend GetSchedulePlainArgsBuilder.() -> Unit): GetScheduleResult {
        val builder = GetSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduleResultToKotlin(getSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a single software update configuration by name.
     * Azure REST API version: 2019-06-01.
     * Other available API versions: 2017-05-15-preview, 2023-05-15-preview.
     * @param argument null
     * @return Software update configuration properties.
     */
    public suspend fun getSoftwareUpdateConfigurationByName(argument: GetSoftwareUpdateConfigurationByNamePlainArgs): GetSoftwareUpdateConfigurationByNameResult =
        getSoftwareUpdateConfigurationByNameResultToKotlin(getSoftwareUpdateConfigurationByNamePlain(argument.toJava()).await())

    /**
     * @see [getSoftwareUpdateConfigurationByName].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param softwareUpdateConfigurationName The name of the software update configuration to be created.
     * @return Software update configuration properties.
     */
    public suspend fun getSoftwareUpdateConfigurationByName(
        automationAccountName: String,
        resourceGroupName: String,
        softwareUpdateConfigurationName: String,
    ): GetSoftwareUpdateConfigurationByNameResult {
        val argument = GetSoftwareUpdateConfigurationByNamePlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            softwareUpdateConfigurationName = softwareUpdateConfigurationName,
        )
        return getSoftwareUpdateConfigurationByNameResultToKotlin(getSoftwareUpdateConfigurationByNamePlain(argument.toJava()).await())
    }

    /**
     * @see [getSoftwareUpdateConfigurationByName].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetSoftwareUpdateConfigurationByNamePlainArgs].
     * @return Software update configuration properties.
     */
    public suspend fun getSoftwareUpdateConfigurationByName(argument: suspend GetSoftwareUpdateConfigurationByNamePlainArgsBuilder.() -> Unit): GetSoftwareUpdateConfigurationByNameResult {
        val builder = GetSoftwareUpdateConfigurationByNamePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSoftwareUpdateConfigurationByNameResultToKotlin(getSoftwareUpdateConfigurationByNamePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the source control identified by source control name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the source control.
     */
    public suspend fun getSourceControl(argument: GetSourceControlPlainArgs): GetSourceControlResult =
        getSourceControlResultToKotlin(getSourceControlPlain(argument.toJava()).await())

    /**
     * @see [getSourceControl].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param sourceControlName The name of source control.
     * @return Definition of the source control.
     */
    public suspend fun getSourceControl(
        automationAccountName: String,
        resourceGroupName: String,
        sourceControlName: String,
    ): GetSourceControlResult {
        val argument = GetSourceControlPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            sourceControlName = sourceControlName,
        )
        return getSourceControlResultToKotlin(getSourceControlPlain(argument.toJava()).await())
    }

    /**
     * @see [getSourceControl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetSourceControlPlainArgs].
     * @return Definition of the source control.
     */
    public suspend fun getSourceControl(argument: suspend GetSourceControlPlainArgsBuilder.() -> Unit): GetSourceControlResult {
        val builder = GetSourceControlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSourceControlResultToKotlin(getSourceControlPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the variable identified by variable name.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return Definition of the variable.
     */
    public suspend fun getVariable(argument: GetVariablePlainArgs): GetVariableResult =
        getVariableResultToKotlin(getVariablePlain(argument.toJava()).await())

    /**
     * @see [getVariable].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param variableName The name of variable.
     * @return Definition of the variable.
     */
    public suspend fun getVariable(
        automationAccountName: String,
        resourceGroupName: String,
        variableName: String,
    ): GetVariableResult {
        val argument = GetVariablePlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            variableName = variableName,
        )
        return getVariableResultToKotlin(getVariablePlain(argument.toJava()).await())
    }

    /**
     * @see [getVariable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetVariablePlainArgs].
     * @return Definition of the variable.
     */
    public suspend fun getVariable(argument: suspend GetVariablePlainArgsBuilder.() -> Unit): GetVariableResult {
        val builder = GetVariablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVariableResultToKotlin(getVariablePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the watcher identified by watcher name.
     * Azure REST API version: 2020-01-13-preview.
     * Other available API versions: 2023-05-15-preview.
     * @param argument null
     * @return Definition of the watcher type.
     */
    public suspend fun getWatcher(argument: GetWatcherPlainArgs): GetWatcherResult =
        getWatcherResultToKotlin(getWatcherPlain(argument.toJava()).await())

    /**
     * @see [getWatcher].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param watcherName The watcher name.
     * @return Definition of the watcher type.
     */
    public suspend fun getWatcher(
        automationAccountName: String,
        resourceGroupName: String,
        watcherName: String,
    ): GetWatcherResult {
        val argument = GetWatcherPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            watcherName = watcherName,
        )
        return getWatcherResultToKotlin(getWatcherPlain(argument.toJava()).await())
    }

    /**
     * @see [getWatcher].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetWatcherPlainArgs].
     * @return Definition of the watcher type.
     */
    public suspend fun getWatcher(argument: suspend GetWatcherPlainArgsBuilder.() -> Unit): GetWatcherResult {
        val builder = GetWatcherPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWatcherResultToKotlin(getWatcherPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the webhook identified by webhook name.
     * Azure REST API version: 2015-10-31.
     * Other available API versions: 2023-05-15-preview.
     * @param argument null
     * @return Definition of the webhook type.
     */
    public suspend fun getWebhook(argument: GetWebhookPlainArgs): GetWebhookResult =
        getWebhookResultToKotlin(getWebhookPlain(argument.toJava()).await())

    /**
     * @see [getWebhook].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @param webhookName The webhook name.
     * @return Definition of the webhook type.
     */
    public suspend fun getWebhook(
        automationAccountName: String,
        resourceGroupName: String,
        webhookName: String,
    ): GetWebhookResult {
        val argument = GetWebhookPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
            webhookName = webhookName,
        )
        return getWebhookResultToKotlin(getWebhookPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebhook].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;GetWebhookPlainArgs].
     * @return Definition of the webhook type.
     */
    public suspend fun getWebhook(argument: suspend GetWebhookPlainArgsBuilder.() -> Unit): GetWebhookResult {
        val builder = GetWebhookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebhookResultToKotlin(getWebhookPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the deleted runbooks for an automation account.
     * Azure REST API version: 2023-05-15-preview.
     * @param argument null
     * @return The response model for the list deleted runbook.
     */
    public suspend fun listAutomationAccountDeletedRunbooks(argument: ListAutomationAccountDeletedRunbooksPlainArgs): ListAutomationAccountDeletedRunbooksResult =
        listAutomationAccountDeletedRunbooksResultToKotlin(listAutomationAccountDeletedRunbooksPlain(argument.toJava()).await())

    /**
     * @see [listAutomationAccountDeletedRunbooks].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return The response model for the list deleted runbook.
     */
    public suspend fun listAutomationAccountDeletedRunbooks(
        automationAccountName: String,
        resourceGroupName: String,
    ): ListAutomationAccountDeletedRunbooksResult {
        val argument = ListAutomationAccountDeletedRunbooksPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return listAutomationAccountDeletedRunbooksResultToKotlin(listAutomationAccountDeletedRunbooksPlain(argument.toJava()).await())
    }

    /**
     * @see [listAutomationAccountDeletedRunbooks].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;ListAutomationAccountDeletedRunbooksPlainArgs].
     * @return The response model for the list deleted runbook.
     */
    public suspend fun listAutomationAccountDeletedRunbooks(argument: suspend ListAutomationAccountDeletedRunbooksPlainArgsBuilder.() -> Unit): ListAutomationAccountDeletedRunbooksResult {
        val builder = ListAutomationAccountDeletedRunbooksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAutomationAccountDeletedRunbooksResultToKotlin(listAutomationAccountDeletedRunbooksPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the automation keys for an account.
     * Azure REST API version: 2022-08-08.
     * Other available API versions: 2023-05-15-preview, 2023-11-01.
     * @param argument null
     * @return null
     */
    public suspend fun listKeyByAutomationAccount(argument: ListKeyByAutomationAccountPlainArgs): ListKeyByAutomationAccountResult =
        listKeyByAutomationAccountResultToKotlin(listKeyByAutomationAccountPlain(argument.toJava()).await())

    /**
     * @see [listKeyByAutomationAccount].
     * @param automationAccountName The name of the automation account.
     * @param resourceGroupName Name of an Azure Resource group.
     * @return null
     */
    public suspend fun listKeyByAutomationAccount(
        automationAccountName: String,
        resourceGroupName: String,
    ): ListKeyByAutomationAccountResult {
        val argument = ListKeyByAutomationAccountPlainArgs(
            automationAccountName = automationAccountName,
            resourceGroupName = resourceGroupName,
        )
        return listKeyByAutomationAccountResultToKotlin(listKeyByAutomationAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [listKeyByAutomationAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;automation&#46;kotlin&#46;inputs&#46;ListKeyByAutomationAccountPlainArgs].
     * @return null
     */
    public suspend fun listKeyByAutomationAccount(argument: suspend ListKeyByAutomationAccountPlainArgsBuilder.() -> Unit): ListKeyByAutomationAccountResult {
        val builder = ListKeyByAutomationAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listKeyByAutomationAccountResultToKotlin(listKeyByAutomationAccountPlain(builtArgument.toJava()).await())
    }
}
