@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.kotlin.outputs.FieldDefinitionResponse
import com.pulumi.azurenative.automation.kotlin.outputs.FieldDefinitionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ConnectionType].
 */
@PulumiTagMarker
public class ConnectionTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionTypeArgs = ConnectionTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionTypeArgsBuilder.() -> Unit) {
        val builder = ConnectionTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectionType {
        val builtJavaResource =
            com.pulumi.azurenative.automation.ConnectionType(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionType(builtJavaResource)
    }
}

/**
 * Definition of the connection type.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create or update connection type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectionType = new AzureNative.Automation.ConnectionType("connectionType", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount22",
 *         ConnectionTypeName = "myCT",
 *         FieldDefinitions =
 *         {
 *             { "myBoolField", new AzureNative.Automation.Inputs.FieldDefinitionArgs
 *             {
 *                 IsEncrypted = false,
 *                 IsOptional = false,
 *                 Type = "bool",
 *             } },
 *             { "myStringField", new AzureNative.Automation.Inputs.FieldDefinitionArgs
 *             {
 *                 IsEncrypted = false,
 *                 IsOptional = false,
 *                 Type = "string",
 *             } },
 *             { "myStringFieldEncrypted", new AzureNative.Automation.Inputs.FieldDefinitionArgs
 *             {
 *                 IsEncrypted = true,
 *                 IsOptional = false,
 *                 Type = "string",
 *             } },
 *         },
 *         IsGlobal = false,
 *         Name = "myCT",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewConnectionType(ctx, "connectionType", &automation.ConnectionTypeArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount22"),
 * 			ConnectionTypeName:    pulumi.String("myCT"),
 * 			FieldDefinitions: automation.FieldDefinitionMap{
 * 				"myBoolField": &automation.FieldDefinitionArgs{
 * 					IsEncrypted: pulumi.Bool(false),
 * 					IsOptional:  pulumi.Bool(false),
 * 					Type:        pulumi.String("bool"),
 * 				},
 * 				"myStringField": &automation.FieldDefinitionArgs{
 * 					IsEncrypted: pulumi.Bool(false),
 * 					IsOptional:  pulumi.Bool(false),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 				"myStringFieldEncrypted": &automation.FieldDefinitionArgs{
 * 					IsEncrypted: pulumi.Bool(true),
 * 					IsOptional:  pulumi.Bool(false),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 			},
 * 			IsGlobal:          pulumi.Bool(false),
 * 			Name:              pulumi.String("myCT"),
 * 			ResourceGroupName: pulumi.String("rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.ConnectionType;
 * import com.pulumi.azurenative.automation.ConnectionTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectionType = new ConnectionType("connectionType", ConnectionTypeArgs.builder()
 *             .automationAccountName("myAutomationAccount22")
 *             .connectionTypeName("myCT")
 *             .fieldDefinitions(Map.ofEntries(
 *                 Map.entry("myBoolField", Map.ofEntries(
 *                     Map.entry("isEncrypted", false),
 *                     Map.entry("isOptional", false),
 *                     Map.entry("type", "bool")
 *                 )),
 *                 Map.entry("myStringField", Map.ofEntries(
 *                     Map.entry("isEncrypted", false),
 *                     Map.entry("isOptional", false),
 *                     Map.entry("type", "string")
 *                 )),
 *                 Map.entry("myStringFieldEncrypted", Map.ofEntries(
 *                     Map.entry("isEncrypted", true),
 *                     Map.entry("isOptional", false),
 *                     Map.entry("type", "string")
 *                 ))
 *             ))
 *             .isGlobal(false)
 *             .name("myCT")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:ConnectionType myCT /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/connectionTypes/{connectionTypeName}
 * ```
 */
public class ConnectionType internal constructor(
    override val javaResource: com.pulumi.azurenative.automation.ConnectionType,
) : KotlinCustomResource(javaResource, ConnectionTypeMapper) {
    /**
     * Gets the creation time.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the field definitions of the connection type.
     */
    public val fieldDefinitions: Output<Map<String, FieldDefinitionResponse>>
        get() = javaResource.fieldDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> toKotlin(args0) }))
            }).toMap()
        })

    /**
     * Gets or sets a Boolean value to indicate if the connection type is global.
     */
    public val isGlobal: Output<Boolean>?
        get() = javaResource.isGlobal().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the last modified time.
     */
    public val lastModifiedTime: Output<String>?
        get() = javaResource.lastModifiedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the name of the connection type.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectionTypeMapper : ResourceMapper<ConnectionType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.automation.ConnectionType::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionType = ConnectionType(
        javaResource as
            com.pulumi.azurenative.automation.ConnectionType,
    )
}

/**
 * @see [ConnectionType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionType].
 */
public suspend fun connectionType(
    name: String,
    block: suspend ConnectionTypeResourceBuilder.() -> Unit,
): ConnectionType {
    val builder = ConnectionTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionType(name: String): ConnectionType {
    val builder = ConnectionTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
