@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.automation.kotlin

import com.pulumi.azurenative.automation.CredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Definition of the credential.
 * Azure REST API version: 2022-08-08. Prior API version in Azure Native 1.x: 2019-06-01.
 * Other available API versions: 2023-05-15-preview, 2023-11-01.
 * ## Example Usage
 * ### Create a credential
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credential = new AzureNative.Automation.Credential("credential", new()
 *     {
 *         AutomationAccountName = "myAutomationAccount18",
 *         CredentialName = "myCredential",
 *         Description = "my description goes here",
 *         Name = "myCredential",
 *         Password = "<password>",
 *         ResourceGroupName = "rg",
 *         UserName = "mylingaiah",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/automation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := automation.NewCredential(ctx, "credential", &automation.CredentialArgs{
 * 			AutomationAccountName: pulumi.String("myAutomationAccount18"),
 * 			CredentialName:        pulumi.String("myCredential"),
 * 			Description:           pulumi.String("my description goes here"),
 * 			Name:                  pulumi.String("myCredential"),
 * 			Password:              pulumi.String("<password>"),
 * 			ResourceGroupName:     pulumi.String("rg"),
 * 			UserName:              pulumi.String("mylingaiah"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.automation.Credential;
 * import com.pulumi.azurenative.automation.CredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credential = new Credential("credential", CredentialArgs.builder()
 *             .automationAccountName("myAutomationAccount18")
 *             .credentialName("myCredential")
 *             .description("my description goes here")
 *             .name("myCredential")
 *             .password("<password>")
 *             .resourceGroupName("rg")
 *             .userName("mylingaiah")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:automation:Credential myCredential /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automation/automationAccounts/{automationAccountName}/credentials/{credentialName}
 * ```
 * @property automationAccountName The name of the automation account.
 * @property credentialName The parameters supplied to the create or update credential operation.
 * @property description Gets or sets the description of the credential.
 * @property name Gets or sets the name of the credential.
 * @property password Gets or sets the password of the credential.
 * @property resourceGroupName Name of an Azure Resource group.
 * @property userName Gets or sets the user name of the credential.
 */
public data class CredentialArgs(
    public val automationAccountName: Output<String>? = null,
    public val credentialName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.automation.CredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.automation.CredentialArgs =
        com.pulumi.azurenative.automation.CredentialArgs.builder()
            .automationAccountName(automationAccountName?.applyValue({ args0 -> args0 }))
            .credentialName(credentialName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CredentialArgs].
 */
@PulumiTagMarker
public class CredentialArgsBuilder internal constructor() {
    private var automationAccountName: Output<String>? = null

    private var credentialName: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The name of the automation account.
     */
    @JvmName("bpjkcwkokkterryh")
    public suspend fun automationAccountName(`value`: Output<String>) {
        this.automationAccountName = value
    }

    /**
     * @param value The parameters supplied to the create or update credential operation.
     */
    @JvmName("jgbhqxlvmjogklkb")
    public suspend fun credentialName(`value`: Output<String>) {
        this.credentialName = value
    }

    /**
     * @param value Gets or sets the description of the credential.
     */
    @JvmName("bmfiajgmrmylumgm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the name of the credential.
     */
    @JvmName("wbcopsghfjsxpbks")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the password of the credential.
     */
    @JvmName("qoulkqvgpqttweix")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("prcyvqlgevcysjgx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the user name of the credential.
     */
    @JvmName("dwqsxaksxflkmvgy")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The name of the automation account.
     */
    @JvmName("bfwyuujhfvxqttgx")
    public suspend fun automationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationAccountName = mapped
    }

    /**
     * @param value The parameters supplied to the create or update credential operation.
     */
    @JvmName("sgrirepskiqruqxb")
    public suspend fun credentialName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialName = mapped
    }

    /**
     * @param value Gets or sets the description of the credential.
     */
    @JvmName("epqaafmlbkmyedqw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the name of the credential.
     */
    @JvmName("aroontxiyfvnqymi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the password of the credential.
     */
    @JvmName("omlcbkvcdtsupvdn")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Name of an Azure Resource group.
     */
    @JvmName("swvgijmnpeukfqcp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the user name of the credential.
     */
    @JvmName("agtkouunksxffwco")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): CredentialArgs = CredentialArgs(
        automationAccountName = automationAccountName,
        credentialName = credentialName,
        description = description,
        name = name,
        password = password,
        resourceGroupName = resourceGroupName,
        userName = userName,
    )
}
